package com.biz.crm.worksign.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡记录表 
 * 
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
public interface SfaWorkSignRecordMapper extends BaseMapper<SfaWorkSignRecordEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    List<SfaWorkSignRecordRespVo> findList(Page<SfaWorkSignRecordRespVo> page, @Param("vo") SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 查询异常考勤信息(迟到、早退、未打卡)
     * @return
     */
    List<SfaWorkSignRecordRespVo> findExceptionSign(@Param("userName") String userName,@Param("beginDate") String beginDate,@Param("endDate") String endDate);

    /**
     * 获取打卡明细列表
     * @return
     */
    List<String> getRuleInfoIds(@Param("userName") String userName,@Param("beginDate") String beginDate,@Param("endDate") String endDate);


    /**
     * 查询历史考勤
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.ws_pos_code",orgCode = "t.ws_org_code")
    List<SfaSignHistoryListRespVo> findSignHistory(Page<SfaSignHistoryListRespVo> page
            , @Param("vo") SfaSignHistoryListReqVo reqVo);

    /**
     * 删除指定时间数据
     * @param ruleDate
     */
    void deleteByDate(@Param("ruleDate") String ruleDate);
}
