package com.biz.crm.worksign.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤规则明细表 
 * 
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
public interface SfaWorkSignRuleInfoMapper extends BaseMapper<SfaWorkSignRuleInfoEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSignRuleInfoReqVo
     * @return
     */
    List<SfaWorkSignRuleInfoRespVo> findList(Page<SfaWorkSignRuleInfoRespVo> page, @Param("vo") SfaWorkSignRuleInfoReqVo sfaWorkSignRuleInfoReqVo);


    /**
     * 查询考勤明细报表列表
     * @param page
     * @param reqVo
     * @return
     */
    List<SfaWorkSignInfoRespVo> findWorkSignInfoList(Page<SfaWorkSignInfoRespVo> page,@Param("vo")SfaWorkSignInfoReqVo reqVo);

}
