package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 异常报备 实体类
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_exception_report")
@CrmTable(name = "sfa_exception_report", tableNote = "异常报备 ", indexes = {
        @Index(name = "sfa_exception_report_index1", columnList = "user_name, begin_time, end_time"),
        @Index(name = "sfa_exception_report_index2", columnList = "audit_task_id")})
public class SfaExceptionReportEntity extends CrmExtTenEntity<SfaExceptionReportEntity> {


    /**
     * 异常说明
     */
    @CrmColumn(name = "report_reason", length = 512, note = "异常说明")
    private String reportReason;

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "user_name", length = 100, note = "人员账号 人员账号")
    private String userName;

    /**
     * 人员姓名 人员姓名
     */
    @CrmColumn(name = "real_name", length = 100, note = "人员姓名 人员姓名")
    private String realName;

    /**
     * 职位编码 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码 职位编码")
    private String posCode;

    /**
     * 职位名称 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称 职位名称")
    private String posName;

    /**
     * 所属组织编码 所属组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "所属组织编码 所属组织编码")
    private String orgCode;

    /**
     * 所属组织名称 所属组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "所属组织名称 所属组织名称")
    private String orgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 32, note = "上级组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 64, note = "上级组织名称")
    private String parentOrgName;

    /**
     * 申请日期 申请日期(yyyy-MM-dd HH:mm:dd)
     */
    @CrmColumn(name = "application_date", length = 512, note = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    /**
     * 开始时间 开始时间(yyyy-MM-dd HH)
     */
    @CrmColumn(name = "begin_time", length = 32, note = "开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    /**
     * 结束时间 结束时间(yyyy-MM-dd HH)
     */
    @CrmColumn(name = "end_time", length = 32, note = "结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    /**
     * 审批状态 审批状态
     */
    @CrmColumn(name = "bpm_status", length = 32, note = "审批状态 审批状态")
    private String bpmStatus;

    /**
     * 审核任务id
     */
    @CrmColumn(name = "audit_task_id", length = 512, note = "审核任务id")
    private String auditTaskId;

    /**
     * 异常打卡记录编号
     */
    @CrmColumn(name = "exception_record_ids", length = 4000, note = "异常打卡记录编号")
    private String exceptionRecordIds;

    @CrmColumn(name = "process_no", length =24, note = "流程编号")
    private String processNo;

}
