package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author ren.gang
 * @ClassName SfaLeaveCancelEntity.java
 * @Description 销假信息 实体类
 * @createTime 2020年12月09日 22:06:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_leave_cancel")
@CrmTable(name = "sfa_leave_cancel", tableNote = "销假信息")
public class SfaLeaveCancelEntity extends CrmExtTenEntity<SfaLeaveCancelEntity> {

    /**
     * 请假id
     */
    @CrmColumn(name = "leave_id", length = 32, note = "请假id")
    private String leaveId;

    /**
     * 申请日期(yyyy-MM-dd HH:mm:dd)
     */
    @CrmColumn(name = "application_date", length = 32, note = "申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_time", length = 64, note = "开始时间")
    private String beginTime;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_time", length = 64, note = "结束时间")
    private String endTime;

    /**
     * 销假天数
     */
    @CrmColumn(name = "cancel_days", length = 32, note = "销假天数")
    private String cancelDays;

    /**
     * 销假日期明细
     */
    @CrmColumn(name = "time_info_list_json", length = 512, note = "销假日期明细")
    private String timeInfoListJson;

    /**
     * 审核任务id
     */
    @CrmColumn(name = "audit_task_id", length = 512, note = "审核任务id")
    private String auditTaskId;

    /**
     * 审批状态 审批状态
     */
    @CrmColumn(name = "bpm_status", length = 32, note = "审批状态 审批状态")
    private String bpmStatus;

    /**
     * 审批通过时间
     */
    @CrmColumn(name = "pass_status_date", length = 32, note = "审批通过时间")
    private String passStatusDate;


}
