package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExt50Entity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 请假申请 实体类
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_leave")
@CrmTable(name = "sfa_leave", tableNote = "请假申请", indexes = {
        @Index(name = "sfa_leave_index1", columnList = "user_name, begin_time, end_time"),
        @Index(name = "sfa_leave_index2", columnList = "audit_task_id")})
public class SfaLeaveEntity extends CrmExt50Entity<SfaLeaveEntity> {

    /**
     * 请假类型 请假类型
     */
    @CrmColumn(name = "leave_type", length = 32, note = "请假类型 请假类型")
    private String leaveType;

    /**
     * 请假事由 请假事由
     */
    @CrmColumn(name = "leave_reason", length = 512, note = "请假事由 请假事由")
    private String leaveReason;

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "user_name", length = 32, note = "人员账号 人员账号")
    private String userName;

    /**
     * 人员姓名 人员姓名
     */
    @CrmColumn(name = "real_name", length = 100, note = "人员姓名 人员姓名")
    private String realName;

    /**
     * 职位编码 职位编码
     */
    @CrmColumn(name = "pos_code", length = 32, note = "职位编码 职位编码")
    private String posCode;

    /**
     * 职位名称 职位名称
     */
    @CrmColumn(name = "pos_name", length = 100, note = "职位名称 职位名称")
    private String posName;

    /**
     * 所属组织编码 所属组织编码
     */
    @CrmColumn(name = "org_code", length = 32, note = "所属组织编码 所属组织编码")
    private String orgCode;

    /**
     * 所属组织名称 所属组织名称
     */
    @CrmColumn(name = "org_name", length = 100, note = "所属组织名称 所属组织名称")
    private String orgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 32, note = "上级组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 64, note = "上级组织名称")
    private String parentOrgName;

    /**
     * 申请日期 申请日期(yyyy-MM-dd HH:mm:dd)
     */
    @CrmColumn(name = "application_date", length = 512, note = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    /**
     * 开始时间 开始时间(yyyy-MM-dd HH)
     */
    @CrmColumn(name = "begin_time", length = 32, note = "开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    /**
     * 结束时间 结束时间(yyyy-MM-dd HH)
     */
    @CrmColumn(name = "end_time", length = 32, note = "结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    /**
     * 日期明细json
     */
    @CrmColumn(name = "time_info_list_json", length = 512, note = "日期明细json")
    private String timeInfoListJson;

    /**
     * 请假时长(天)
     */
    @CrmColumn(name = "leave_duration", length = 512, note = "请假时长(天)")
    private String leaveDuration;

    /**
     * 非工作日
     */
    @CrmColumn(name = "non_work_date_list_json", length = 512, note = "非工作日")
    private String nonWorkDateListJson;

    /**
     * 审批状态 审批状态
     */
    @CrmColumn(name = "bpm_status", length = 32, note = "审批状态 审批状态")
    private String bpmStatus;

    /**
     * 审批通过时间
     */
    @CrmColumn(name = "pass_status_date", length = 32, note = "审批通过时间")
    private String passStatusDate;

    /**
     * 已抵扣天数
     */
    @CrmColumn(name = "use_days", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "已抵扣天数")
    private BigDecimal useDays;

    /**
     * 剩余抵扣天数
     */
    @CrmColumn(name = "last_days", mysqlType = "decimal(10,2)", oracleType = "NUMBER(10,2)", note = "剩余抵扣天数")
    private BigDecimal lastDays;

    /**
     * 使用抵扣的id集合
     */
    @CrmColumn(name = "use_deduction_ids", length = 500, note = "使用抵扣的id集合")
    private String useDeductionIds;

    /**
     * 审核任务id
     */
    @CrmColumn(name = "audit_task_id", length = 512, note = "审核任务id")
    private String auditTaskId;

    /**
     * 销假天数
     */
    @CrmColumn(name = "cancel_days", length = 512, note = "销假天数")
    private String cancelDays;


    /**
     * 销假天数
     */
    @CrmColumn(name = "process_no", length = 24, note = "流程编号")
    private String processNo;
}
