package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author ren.gang
 * @ClassName SfaLeaveAttachmentEntity.java
 * @Description 考勤相关申请附件信息 实体类
 * @createTime 2020年12月04日 23:00:00
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_sign_apply_attachment")
@CrmTable(name = "sfa_sign_apply_attachment", tableNote = "考勤相关申请附件信息")
public class SfaSignApplyAttachmentEntity extends CrmExtTenEntity<SfaSignApplyAttachmentEntity> {

    /**
     * 申请类型（leave-请假，exception-异常报备）
     */
    @CrmColumn(name = "apply_type", length = 64, note = "申请类型（leave-请假，exception-异常报备）")
    private String applyType;

    /**
     * 来源id
     */
    @CrmColumn(name = "source_id", length = 64, note = "来源id")
    private String sourceId;

    /**
     * 附件列表json
     */
    @CrmColumn(name = "attachment_list_json", mysqlType = "text", oracleType = "CLOB", note = "附件列表json")
    private String attachmentListJson;

}
