package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 考勤照片 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_picture")
@CrmTable(name = "sfa_work_sign_picture", tableNote = "考勤照片",indexes = {
        @Index(name = "work_sign_picture_index1",columnList = "ws_record_id")
})
public class SfaWorkSignPictureEntity extends CrmExtTenEntity<SfaWorkSignPictureEntity> {

    /**
     * 打卡记录id 打卡记录id
     */
    @CrmColumn(name = "ws_record_id", length = 32, note = "打卡记录id 打卡记录id")
    private String wsRecordId;

    /**
     * 照片路径(物理路径) 照片路径(物理路径)
     */
    @CrmColumn(name = "pic_path", length = 100, note = "照片路径(物理路径) 照片路径(物理路径)")
    private String picPath;

    /**
     * 照片地址 照片地址
     */
    @CrmColumn(name = "pic_url", length = 100, note = "照片地址 照片地址")
    private String picUrl;

    /**
     * 照片描述 照片描述
     */
    @CrmColumn(name = "pic_desc", length = 100, note = "照片描述 照片描述")
    private String picDesc;

}
