package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.google.common.collect.Lists;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.util.List;

/**
 * 考勤打卡记录表 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_record")
@CrmTable(name = "sfa_work_sign_record", tableNote = "考勤打卡记录表",indexes = {
        @Index(name = "sfa_work_sign_record_index1",columnList = "ws_rule_info_id"),
        @Index(name = "sfa_work_sign_record_index2",columnList = "rule_date, rule_code, used_status")
})
public class SfaWorkSignRecordEntity extends CrmExtTenEntity<SfaWorkSignRecordEntity> {

    /**
     * 考勤规则明细表id 考勤规则明细表id
     */
    @CrmColumn(name = "ws_rule_info_id", length = 64, note = "考勤规则明细表id 考勤规则明细表id")
    private String wsRuleInfoId;

    /**
     * 规则编码 规则编码
     */
    @CrmColumn(name = "rule_code", length = 64, note = "规则编码 规则编码")
    private String ruleCode;

    /**
     * 规则类型 规则类型 STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则
     */
    @CrmColumn(name = "rule_type", length = 64, note = "规则类型 规则类型 STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则")
    private String ruleType;

    /**
     * 打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;
     */
    @CrmColumn(name = "work_sign_type", length = 64, note = "打卡类型 CLOCK_IN : 上班签到; CLOCK_OUT : 下班签退;")
    private String workSignType;

    /**
     * 打卡类型描述 打卡类型描述
     */
    @CrmColumn(name = "work_sign_desc", length = 200, note = "打卡类型描述 打卡类型描述")
    private String workSignDesc;

    @CrmColumn(name = "rule_date", length = 32, note = "考勤日期 考勤日期（yyyy-MM-dd）")
    private String ruleDate;

    @CrmColumn(name = "used_status", length = 4, note = "是否已经使用(Y:已经打卡,N:未处理)，如果重新新生成根据该字段判断")
    private String usedStatus;

    /**
     * 考勤签到时间(HH:mm:ss)
     */
    @CrmColumn(name = "work_sign_time", length = 32, note = "考勤签到时间(HH:mm:ss)")
    private String workSignTime;

    /**
     * 考勤时间规则id
     */
    @CrmColumn(name = "sfa_sign_time_id", length = 64, note = "考勤时间规则id")
    private String sfaSignTimeId;

    /**
     * 考勤时间规则-签到时间(HH:mm:ss)
     */
    @CrmColumn(name = "sfa_sign_time", length = 20, note = "考勤时间规则-签到时间(HH:mm:ss)")
    private String sfaSignTime;

    /**
     * 考勤时间规则-签到开始时间(HH:mm:ss)
     */
    @CrmColumn(name = "sfa_sign_time_begin", length = 20, note = "考勤时间规则-签到开始时间(HH:mm:ss)")
    private String sfaSignTimeBegin;

    /**
     * 考勤时间规则-签到结束时间(HH:mm:ss)
     */
    @CrmColumn(name = "sfa_sign_time_end", length = 20, note = "考勤时间规则-签到结束时间(HH:mm:ss)")
    private String sfaSignTimeEnd;

    /**
     * 考勤地点 考勤地点
     */
    @CrmColumn(name = "work_sign_place", length = 500, note = "考勤地点 考勤地点")
    private String workSignPlace;

    /**
     * 打卡经度 打卡经度
     */
    @CrmColumn(name = "lng_in", length = 32, note = "打卡经度 打卡经度")
    private String lngIn;

    /**
     * 打卡纬度 打卡纬度
     */
    @CrmColumn(name = "lat_in", length = 32, note = "打卡纬度 打卡纬度")
    private String latIn;

    /**
     * 考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;
     */
    @CrmColumn(name = "work_sign_status", length = 64, note = "考勤状态 NONE:未打卡;OK:正常;BE_LATE:迟到;LEAVE_EARLY:早退;")
    private String workSignStatus;

    /**
     * 考勤地点状态  OK : 正常; EX : 异常;
     */
    @CrmColumn(name = "ws_place_status", length = 64, note = "考勤地点状态  OK : 正常; EX : 异常;")
    private String wsPlaceStatus;

    /**
     * 打卡人员账号 打卡人员账号
     */
    @CrmColumn(name = "ws_user_name", length = 100, note = "打卡人员账号 打卡人员账号")
    private String wsUserName;

    /**
     * 打卡人员名称 打卡人员名称
     */
    @CrmColumn(name = "ws_real_name", length = 200, note = "打卡人员名称 打卡人员名称")
    private String wsRealName;

    /**
     * 打卡职位编码 打卡职位编码
     */
    @CrmColumn(name = "ws_pos_code", length = 64, note = "打卡职位编码 打卡职位编码")
    private String wsPosCode;

    /**
     * 打卡职位名称 打卡职位名称
     */
    @CrmColumn(name = "ws_pos_name", length = 200, note = "打卡职位名称 打卡职位名称")
    private String wsPosName;

    /**
     * 打卡组织编码 打卡组织编码
     */
    @CrmColumn(name = "ws_org_code", length = 64, note = "打卡组织编码 打卡组织编码")
    private String wsOrgCode;

    /**
     * 打卡组织名称 打卡组织名称
     */
    @CrmColumn(name = "ws_org_name", length = 200, note = "打卡组织名称 打卡组织名称")
    private String wsOrgName;
    /**
     * 上级组织编码 组织编码
     */
    @CrmColumn(name = "ws_parent_org_code", length = 32, note = "上级组织编码 组织编码")
    private String wsParentOrgCode;

    /**
     * 上级组织名称 组织名称
     */
    @CrmColumn(name = "ws_parent_org_name", length = 64, note = "上级组织名称 组织名称")
    private String wsParentOrgName;

    /**
     * 异常备注
     */
    @CrmColumn(name = "exception_remarks", length = 2000, note = "异常备注")
    private String exceptionRemarks;

    /**
     * 组装上下班签到记录
     * @param infoEntity
     * @return
     */
    public static List<SfaWorkSignRecordEntity> buildClockInOut(SfaWorkSignRuleInfoEntity infoEntity, SfaWorkSignTimeEntity signTimeEntity){
        // 上班签到
        SfaWorkSignRecordEntity clockIn = new SfaWorkSignRecordEntity();
        clockIn.setWsRuleInfoId(infoEntity.getId());
        clockIn.setSfaSignTimeId(signTimeEntity.getId());
        clockIn.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.NONE.getVal());
        clockIn.setWsUserName(infoEntity.getUserName());
        clockIn.setWsRealName(infoEntity.getRealName());
        clockIn.setWsPosCode(infoEntity.getPosCode());
        clockIn.setWsPosName(infoEntity.getPosName());
        clockIn.setWsOrgCode(infoEntity.getOrgCode());
        clockIn.setWsOrgName(infoEntity.getOrgName());
        clockIn.setWsParentOrgCode(infoEntity.getParentOrgCode());
        clockIn.setWsParentOrgName(infoEntity.getParentOrgName());
        clockIn.setUsedStatus(infoEntity.getUsedStatus());
        clockIn.setRuleDate(infoEntity.getRuleDate());
        clockIn.setRuleCode(infoEntity.getRuleCode());
        clockIn.setRuleType(infoEntity.getRuleType());
        // 下班签退
        SfaWorkSignRecordEntity clockOut = CrmBeanUtil.copy(clockIn, SfaWorkSignRecordEntity.class);
        clockIn.setWorkSignType(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
        clockIn.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getDesc());
        clockOut.setWorkSignType(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
        clockOut.setWorkSignDesc(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getDesc());

        // 打卡时间设置-上班
        clockIn.setSfaSignTime(signTimeEntity.getGotoTime());
        clockIn.setSfaSignTimeBegin(signTimeEntity.getGotoStartTime());
        clockIn.setSfaSignTimeEnd(signTimeEntity.getGotoEndTime());
        // 打卡时间设置-下班
        clockOut.setSfaSignTime(signTimeEntity.getGooffTime());
        clockOut.setSfaSignTimeBegin(signTimeEntity.getGooffStartTime());
        clockOut.setSfaSignTimeEnd(signTimeEntity.getGooffEndTime());

        return Lists.newArrayList(clockIn, clockOut);
    }

}
