package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.Index;
import java.time.LocalTime;
import java.util.List;

/**
 * 考勤规则明细表 实体类
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_rule_info")
@CrmTable(name = "sfa_work_sign_rule_info", tableNote = "考勤规则明细表",indexes = {
//        @Index(name = "SFA_WORK_SIGN_RULE_INFO_INDEX1",columnList = "USER_NAME, RULE_DATE",unique = true),
//        @Index(name = "SFA_WORK_SIGN_RULE_INFO_INDEX2",columnList = "rule_date,rule_code,used_status"),
        @Index(name = "SFA_WORK_SIGN_RULE_INFO_INDEX3",columnList = "id,rule_code,rule_name")
})
public class SfaWorkSignRuleInfoEntity extends CrmExtTenEntity<SfaWorkSignRuleInfoEntity> {

    /**
     * 人员账号 人员账号
     */
    @CrmColumn(name = "user_name", length = 100, note = "人员账号 人员账号")
    private String userName;

    /**
     * 人员名称 人员名称
     */
    @CrmColumn(name = "real_name", length = 200, note = "人员名称 人员名称")
    private String realName;

    /**
     * 职位编码 职位编码
     */
    @CrmColumn(name = "pos_code", length = 64, note = "职位编码 职位编码")
    private String posCode;

    /**
     * 职位名称 职位名称
     */
    @CrmColumn(name = "pos_name", length = 200, note = "职位名称 职位名称")
    private String posName;

    /**
     * 组织编码 组织编码
     */
    @CrmColumn(name = "org_code", length = 64, note = "组织编码 组织编码")
    private String orgCode;

    /**
     * 组织名称 组织名称
     */
    @CrmColumn(name = "org_name", length = 200, note = "组织名称 组织名称")
    private String orgName;

    /**
     * 上级组织编码 组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 32, note = "上级组织编码 组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称 组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 64, note = "上级组织名称 组织名称")
    private String parentOrgName;

    /**
     * 规则编码 规则编码
     */
    @CrmColumn(name = "rule_code", length = 64, note = "规则编码 规则编码")
    private String ruleCode;

    /**
     * 规则名称 规则名称
     */
    @CrmColumn(name = "rule_name", length = 200, note = "规则名称 规则名称")
    private String ruleName;

    /**
     * 规则类型 规则类型 STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则
     */
    @CrmColumn(name = "rule_type", length = 64, note = "规则类型 规则类型 STATIC:固定时间上下班规则/FREE_TIME:自由时间上下班规则")
    private String ruleType;
    /**
     * 工作日调整申请时是否遵循此规则(前端气泡)（Y/N 默认N）
     */
    @CrmColumn(name = "non_working_day_sign_astrict", length = 4, note = "工作日调整申请时是否遵循此规则(前端气泡)（Y/N 默认N）")
    private String nonWorkingDaySignAstrict;
    /**
     * 考勤日期 考勤日期（yyyy-MM-dd）
     */
    @CrmColumn(name = "rule_date", length = 32, note = "考勤日期 考勤日期（yyyy-MM-dd）")
    private String ruleDate;
    @CrmColumn(name = "rule_year", length = 10, note = "考勤日期 考勤日期（yyyy）")
    private String ruleYear;
    @CrmColumn(name = "rule_month", length = 10, note = "考勤日期 考勤日期（MM）")
    private String ruleMonth;
    @CrmColumn(name = "rule_year_month", length = 16, note = "考勤日期 考勤日期（yyyy-MM）")
    private String ruleYearMonth;


    /**
     * 电子围栏;电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)
     */
    @CrmColumn(name = "electron_fence", length = 64, note = "电子围栏;电子围栏(NONE:无电子围栏/OUT_SIGN_EX:允许范围外打卡，地点记录为异常/OUT_SIGN_OK:允许范围外打卡，地点记录为正常/NO_OUT_SIGN:不允许范围外打卡)")
    private String electronFence;

    /**
     * 下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)
     */
    @CrmColumn(name = "gooff_work_sign_astrict", length = 64, note = "下班打卡限制：(NO_SIGN:下班不需要打卡;GOTO_WORK_REQUIRED:下班需要打卡，且必须打上班卡才能打下班卡;GOTO_WORK_NO_REQUIRED:下班需要打卡，无需打上班卡，就能打下班卡)")
    private String gooffWorkSignAstrict;

    /**
     * 拍照打卡;拍照打卡(Y:员工打卡时必须拍照)
     */
    @CrmColumn(name = "wsr_photograph", length = 4, note = "拍照打卡;拍照打卡(Y:员工打卡时必须拍照)")
    private String wsrPhotograph;

    /**
     * 是否工作日(Y:是,N:否)
     */
    @CrmColumn(name = "sign_must", length = 10, note = "是否工作日(Y:是,N:否)")
    private String signMust;
    /**
     * 打卡或不打卡类型(10:工作日打卡，，11:特殊日期打卡，20:非工作日不打卡,21:特殊日期不打卡,22:节假日不打卡)
     */
    @CrmColumn(name = "sign_or_non_type", length = 20, note = "打卡或不打卡类型(10:工作日打卡，，11:特殊日期打卡，20:非工作日不打卡,21:特殊日期不打卡,22:节假日不打卡)")
    private String signOrNonType;

    @CrmColumn(name = "used_status", length = 4, note = "是否已经使用(Y:已经打卡,N:未处理)，如果重新新生成根据该字段判断")
    private String usedStatus;

    //考勤打卡记录表
    @TableField(exist = false)
    private List<SfaWorkSignRecordEntity> sfaWorkSignRecords;

    /**
     * 校验当前时间是否在规定的范围内，并返回当前匹配的打卡
     * @param isClockIn 签到true，签退false
     * @param recordEntity 考勤打卡记录集合
     */
    public SfaWorkSignRecordEntity checkSignTime(boolean isClockIn, List<SfaWorkSignRecordEntity> recordEntity){
        if(YesNoEnum.yesNoEnum.NO.getValue().equals(this.signMust) //非工作日
                && YesNoEnum.yesNoEnum.NO.getValue().equals(this.nonWorkingDaySignAstrict)//非工作日是否对打卡进行时间范围规则限制（Y/N 默认N）
        ){
            return recordEntity.get(0);//该规则配置了非工作日不限制打卡时间范围
        }
        for(SfaWorkSignRecordEntity record : recordEntity) {
            String startTimeStr = record.getSfaSignTimeBegin();
            String endTimeStr = record.getSfaSignTimeEnd();
            if (StringUtils.isBlank(startTimeStr)) {
                startTimeStr = record.getSfaSignTime();
            }
            if (StringUtils.isBlank(endTimeStr)) {
                endTimeStr = isClockIn ? CrmDateUtils.TIME_STR_12 : CrmDateUtils.TIME_STR_235959;
            }
            //逻辑结束时间，当结束时间为00:00:00时，会出现当天任何时间都不能打卡的问题，所以在判断时往前推一秒
            if (CrmDateUtils.TIME_STR_00.equals(endTimeStr)) {
                endTimeStr = CrmDateUtils.TIME_STR_235959;
            }

            // 匹配当前时间
            LocalTime localTime = LocalTime.now();
            if(localTime.compareTo(LocalTime.parse(startTimeStr, CrmDateUtils.HHmmss)) >= 0 &&
                    localTime.compareTo(LocalTime.parse(endTimeStr, CrmDateUtils.HHmmss)) <= 0) {
                return record;
            }
        }
        String tag = isClockIn ? "签到" : "签退";
        throw new BusinessException("当前时间不能"+tag);
    }

    /**
     * 构建人员打卡规则明细（不包含时间规则）
     * @param context
     * @param entity
     * @param positionRespVo
     * @return
     */
    public static SfaWorkSignRuleInfoEntity buildRuleInfoEntity(ExecuteSignRuleContext context, SfaWorkSignRuleEntity entity
            , MdmPositionUserOrgRespVo positionRespVo){
        SfaWorkSignRuleInfoEntity infoEntity = buildRuleInfoEntity(entity, context.getSignDate());
        infoEntity.setOrgCode(context.getOrgCodeNow());
        infoEntity.setOrgName(context.getOrgNameNow());
        infoEntity.setParentOrgCode(context.getParentOrgCodeNow());
        infoEntity.setParentOrgName(context.getParentOrgNameNow());
        infoEntity.setPosCode(positionRespVo.getPositionCode());
        infoEntity.setPosName(positionRespVo.getPositionName());
        infoEntity.setRealName(positionRespVo.getFullName());
        infoEntity.setUserName(positionRespVo.getUserName());
        return infoEntity;
    }

    public static SfaWorkSignRuleInfoEntity buildRuleInfoEntity(SfaWorkSignRuleEntity entity, String signDate){
        SfaWorkSignRuleInfoEntity infoEntity = new SfaWorkSignRuleInfoEntity();
        infoEntity.setId(UUIDGenerator.generate());
        infoEntity.setWsrPhotograph(entity.getWsrPhotograph());
        infoEntity.setRuleType(entity.getRuleType());
        infoEntity.setElectronFence(entity.getElectronFence());
        infoEntity.setRuleCode(entity.getRuleCode());
        infoEntity.setRuleName(entity.getRuleName());
        infoEntity.setGooffWorkSignAstrict(entity.getGooffWorkSignAstrict());

        infoEntity.setNonWorkingDaySignAstrict(entity.getNonWorkingDaySignAstrict());
        infoEntity.setUsedStatus(YesNoEnum.yesNoEnum.NO.getValue());
        infoEntity.setRuleDate(signDate);
        if(StringUtils.isNotBlank(signDate)){
            //生成相关辅助字段
            String year = signDate.substring(0,4);
            String month =signDate.substring(6,7).replaceAll("^(0+)", "");
            String yearMonth = signDate.substring(0,7);
            infoEntity.setRuleYear(year);
            infoEntity.setRuleMonth(month);
            infoEntity.setRuleYearMonth(yearMonth);
        }
        return infoEntity;
    }
}
