package com.biz.crm.worksign.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.req.SfaSignRecordBatchReqVo;
import com.biz.crm.worksign.resp.SfaWorkSignOtherTimeRecordRespVo;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 考勤打卡记录表 接口
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
public interface ISfaWorkSignRecordService extends IService<SfaWorkSignRecordEntity> {

    /**
     * 更新考勤明细状态
     * @method updateSignRecord
     * @date: 2021/2/25 15:13
     * @author: YuanZiJian
     * @param sfaSignRecordReqVo 增加考勤记录接收Vo
     * @return void
     */
    void updateSignRecord(SfaSignRecordReqVo sfaSignRecordReqVo);

    /**
     * 批量修改对应id的考勤明细的考勤状态以及考勤地点状态
     * @method updateBatchList
     * @date: 2021/2/25 10:40
     * @author: YuanZiJian
     * @param ids 考勤明细ids
     * @return void
     */
    void updateBatchList(SfaSignRecordBatchReqVo sfaSignRecordBatchReqVo);


    /**
     * 列表
     * @param sfaWorkSignRecordReqVo
     * @return PageResult<SfaWorkSignRecordRespVo>
     */
    PageResult<SfaWorkSignRecordRespVo> findList(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 查询
     * @param sfaWorkSignRecordReqVo
     * @return SfaWorkSignRecordRespVo
     */
    SfaWorkSignRecordRespVo query(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 新增
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    void save(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 更新
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    void update(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 删除
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 启用
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    void enableBatch(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 禁用
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    void disableBatch(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 根据考勤明细id查询打卡记录列表
     * @param signRuleInfoId
     * @return
     */
    List<SfaWorkSignRecordEntity> getRecordsByInfo(String signRuleInfoId, String signType);

    /*********************************************微信端接口查询********************************************************/

    /**
     * 查询当前时间之前，打卡时是否有其他时间段的打卡明细。
     * @param workSignType
     * @return
     */
    List<SfaWorkSignOtherTimeRecordRespVo> getOtherTimeRecordInfo(String workSignType , String id );

    /**
     * 打卡接口
     * @param clockReqVo
     * @return
     */
    Result gotoWorkClock(ClockReqVo clockReqVo);

    /**
     * 查询当前登录人是否需要打卡
     * @return
     */
    NeedClock needWorkSign();

    /**
     * 查询当前登录人是否是自由打卡规则
     * @return
     */
    Boolean isFreeSignRule();

    /**
     * 查询当前位置打卡地点是否异常
     * @return
     */
    Result getPlaceStatus(ClockReqVo clockReqVo);


    /**
     * 自由签到接口
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    Result goFreeSignIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo);

    /**
     * 分片批量保存
     * @param recordEntityList
     */
    void saveBatchPartition(List<SfaWorkSignRecordEntity> recordEntityList);

    /**
     * 分页查询考勤历史
     * @param reqVo
     * @return
     */
    PageResult<SfaSignHistoryListRespVo> findSignHistory(SfaSignHistoryListReqVo reqVo);

    /**
     * 根据ruleInfoId查询列表
     * @param ruleInfoId
     * @return
     */
    List<SfaWorkSignRecordEntity> findByRuleInfoId(String ruleInfoId);

    /**
     * 删除指定时间数据
     * @param ruleDate
     */
    void deleteByDate(String ruleDate);


}

