package com.biz.crm.worksign.service.component;

import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignDaysInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeTimeInfoEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class MonthSignReportQueryContext {
    @Setter(AccessLevel.NONE)
    @ApiModelProperty(value = "查询年月", required = true)
    private String yearMonth;

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
        if(StringUtils.isBlank(this.yearMonth)){
            return;
        }
        this.beginDate = this.yearMonth + "-01";
        LocalDate localDateBegin = LocalDate.parse(this.beginDate, CrmDateUtils.yyyyMMdd);
        LocalDate localDateEnd = localDateBegin.plusMonths(1).plusDays(-1);
        this.endDate = localDateEnd.format(CrmDateUtils.yyyyMMdd);
    }

    @ApiModelProperty("月开始日期")
    private String beginDate;

    @ApiModelProperty("月结束日期")
    private String endDate;

    private Map<String, SfaMonthSignRespVo> userInfoMap;
    private Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockIn;
    private Map<String, Map<String, SfaMonthWorkSignRecordRespVo>> userDayMapOfClockOut;
    private Map<String, MonthSignReportQueryContext.LeaveDetail> userDayMapOfLeave;
    private Map<String, MonthSignReportQueryContext.LeaveCancelDetail> leaveIdDayMapOfLeaveCancel;
    private Map<String, MonthSignReportQueryContext.OvertimeTimeInfoDetail> userDayMapOfOvertimeTime;
//    private Map<String, SfaExceptionReportEntity> userDayMapOfExceptionReport;




    /**
     * 工作日调整明细
     *  @author: luoqi
     *  @Date: 2021-5-14 11:44
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static final class OvertimeTimeInfoDetail {
        /** 用户 */
        private String userName;
        /** 日期 */
        private String leaveDate;

        private String timeType;

        /** 全天 */
        private SfaWorkOvertimeTimeInfoEntity all;
        /** 上午 */
        private SfaWorkOvertimeTimeInfoEntity am;
        /** 下午 */
        private SfaWorkOvertimeTimeInfoEntity pm;

        public static OvertimeTimeInfoDetail build(SfaWorkOvertimeTimeInfoEntity overtimeTimeInfoEntity){
            if(null == overtimeTimeInfoEntity){
                return null;
            }
            OvertimeTimeInfoDetail overtimeTimeInfoDetail = new OvertimeTimeInfoDetail();
            overtimeTimeInfoDetail.leaveDate = overtimeTimeInfoEntity.getOvertimeDate();
            overtimeTimeInfoDetail.userName = overtimeTimeInfoEntity.getUserName();
            String timeType = overtimeTimeInfoEntity.getTimeType();
            if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(timeType)){
                overtimeTimeInfoDetail.all = overtimeTimeInfoEntity;
            } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(timeType)){
                overtimeTimeInfoDetail.am = overtimeTimeInfoEntity;
            }else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(timeType)){
                overtimeTimeInfoDetail.pm = overtimeTimeInfoEntity;
            }
            overtimeTimeInfoDetail.timeType = timeType;
            return overtimeTimeInfoDetail;
        }

        public static OvertimeTimeInfoDetail merge(OvertimeTimeInfoDetail overtimeTimeInfoDetail1, OvertimeTimeInfoDetail overtimeTimeInfoDetail2){
            if(null == overtimeTimeInfoDetail1 || null == overtimeTimeInfoDetail2){
                return null;
            }
            if(null != overtimeTimeInfoDetail1.getAll()){
                return overtimeTimeInfoDetail1;
            }
            if(null != overtimeTimeInfoDetail2.getAll()){
                return overtimeTimeInfoDetail2;
            }
            if(null != overtimeTimeInfoDetail1.getAm()){
                overtimeTimeInfoDetail2.setAm(overtimeTimeInfoDetail1.getAm());
            }
            if(null != overtimeTimeInfoDetail1.getPm()){
                overtimeTimeInfoDetail2.setPm(overtimeTimeInfoDetail1.getPm());
            }
            if(null != overtimeTimeInfoDetail2.am && null != overtimeTimeInfoDetail2.pm){
                overtimeTimeInfoDetail2.timeType = SfaCommonEnum.dataTimeType.ALL_DAY.getValue();
            }
            //todo 临时外出合并 待实现
            return overtimeTimeInfoDetail2;
        }
    }


    /**
     * 请假明细
     *  @author: luoqi
     *  @Date: 2021-5-14 11:44
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static final class LeaveDetail {
//        /** 上午 */
//        public static final String AM = "AM";
//        /** 下午 */
//        public static final String PM = "PM";
//        /** 临时外出(备用待扩展) */
//        public static final String TEMP_OUT = "TEMP_OUT";
        /** 用户 */
        private String userName;
        /** 日期 */
        private String leaveDate;

        private String leaveType;

        private String leaveId;
        /** 全天 */
        private SfaLeaveEntity all;
        /** 上午 */
        private SfaLeaveEntity am;
        /** 下午 */
        private SfaLeaveEntity pm;
        /** 临时外出(备用待扩展) */
        private List<SfaLeaveEntity> tempOut;

        public static LeaveDetail build(SfaApplyTimeInfoReqVo timeInfoReqVo, SfaLeaveEntity leaveEntity){
            if(null == timeInfoReqVo || null == leaveEntity){
                return null;
            }
            LeaveDetail leaveDetail = new LeaveDetail();
            leaveDetail.leaveDate = timeInfoReqVo.getTimeStr();
            leaveDetail.userName = leaveEntity.getUserName();
            String timeType = timeInfoReqVo.getTimeType();
            if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(timeType)){
                leaveDetail.all = leaveEntity;
            } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(timeType)){
                leaveDetail.am = leaveEntity;
            }else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(timeType)){
                leaveDetail.pm = leaveEntity;
            }
            leaveDetail.leaveType = timeType;
            leaveDetail.leaveId = leaveEntity.getId();
            return leaveDetail;
        }

        public static LeaveDetail merge(LeaveDetail leaveDetail1, LeaveDetail leaveDetail2){
            if(null == leaveDetail1 || null == leaveDetail2){
                return null;
            }
            if(null != leaveDetail1.getAll()){
                return leaveDetail1;
            }
            if(null != leaveDetail2.getAll()){
                return leaveDetail2;
            }
            if(null != leaveDetail1.getAm()){
                leaveDetail2.setAm(leaveDetail1.getAm());
            }
            if(null != leaveDetail1.getPm()){
                leaveDetail2.setPm(leaveDetail1.getPm());
            }
            if(null != leaveDetail2.am && null != leaveDetail2.pm){
                leaveDetail2.leaveType = SfaCommonEnum.dataTimeType.ALL_DAY.getValue();
            }
            //todo 临时外出合并 待实现
            return leaveDetail2;
        }
    }


    /**
     * 销假明细
     *  @author: luoqi
     *  @Date: 2021-5-14 11:44
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static final class LeaveCancelDetail {
//        /** 上午 */
//        public static final String AM = "AM";
//        /** 下午 */
//        public static final String PM = "PM";
//        /** 临时外出(备用待扩展) */
//        public static final String TEMP_OUT = "TEMP_OUT";
        /** 日期 */
        private String leaveDate;

        private String leaveType;

        private String leaveId;
        /** 全天 */
        private SfaLeaveCancelEntity all;
        /** 上午 */
        private SfaLeaveCancelEntity am;
        /** 下午 */
        private SfaLeaveCancelEntity pm;
        /** 临时外出(备用待扩展) */
        private List<SfaLeaveCancelEntity> tempOut;

        public static LeaveCancelDetail build(SfaApplyTimeInfoReqVo timeInfoReqVo, SfaLeaveCancelEntity leaveEntity){
            if(null == timeInfoReqVo || null == leaveEntity){
                return null;
            }
            LeaveCancelDetail leaveDetail = new LeaveCancelDetail();
            leaveDetail.leaveDate = timeInfoReqVo.getTimeStr();

            String timeType = timeInfoReqVo.getTimeType();
            if(SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(timeType)){
                leaveDetail.all = leaveEntity;
            } else if(SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(timeType)){
                leaveDetail.am = leaveEntity;
            }else if(SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(timeType)){
                leaveDetail.pm = leaveEntity;
            }
            leaveDetail.leaveType = timeType;
            leaveDetail.leaveId = leaveEntity.getLeaveId();
            return leaveDetail;
        }

        public static LeaveCancelDetail merge(LeaveCancelDetail leaveDetail1, LeaveCancelDetail leaveDetail2){
            if(null == leaveDetail1 || null == leaveDetail2){
                return null;
            }
            if(null != leaveDetail1.getAll()){
                return leaveDetail1;
            }
            if(null != leaveDetail2.getAll()){
                return leaveDetail2;
            }
            if(null != leaveDetail1.getAm()){
                leaveDetail2.setAm(leaveDetail1.getAm());
            }
            if(null != leaveDetail1.getPm()){
                leaveDetail2.setPm(leaveDetail1.getPm());
            }
            if(null != leaveDetail2.am && null != leaveDetail2.pm){
                leaveDetail2.leaveType = SfaCommonEnum.dataTimeType.ALL_DAY.getValue();
            }
            //todo 临时外出合并 待实现
            return leaveDetail2;
        }
    }
}
