package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyAttachmentReqVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.mapper.SfaLeaveAttachmentMapper;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author ren.gang
 * @ClassName SfaLleaveAttachmentServiceImpl.java
 * @Description 请假申请-附件
 * @createTime 2020年12月04日 23:09:00
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaSignApplyAttachmentServiceExpandImpl")
public class SfaSignApplyAttachmentServiceImpl extends ServiceImpl<SfaLeaveAttachmentMapper, SfaSignApplyAttachmentEntity> implements ISfaSignApplyAttachmentService {

    @Resource
    private SfaLeaveAttachmentMapper mapper;

    /**
     * 根据类型和来源查询
     * @param applyType
     * @param sourceId
     * @return
     */
    @Override
    public SfaSignApplyAttachmentEntity getEntity(String applyType, String sourceId) {
        LambdaQueryWrapper<SfaSignApplyAttachmentEntity> wrapper = new LambdaQueryWrapper<SfaSignApplyAttachmentEntity>()
                .eq(SfaSignApplyAttachmentEntity::getApplyType, applyType)
                .eq(SfaSignApplyAttachmentEntity::getSourceId, sourceId);
        return mapper.selectOne(wrapper);
    }

    /**
     * 保存考勤申请相关附件信息，先删除后保存
     * @param applyType 申请类型
     * @param sourceId 来源id
     * @param attachmentList 附件列表
     */
    @Override
    public void save(String applyType, String sourceId, List<SfaApplyAttachmentReqVo> attachmentList) {
        // 先删除原信息
        LambdaQueryWrapper<SfaSignApplyAttachmentEntity> wrapper = new LambdaQueryWrapper<SfaSignApplyAttachmentEntity>()
                .eq(SfaSignApplyAttachmentEntity::getApplyType, applyType)
                .eq(SfaSignApplyAttachmentEntity::getSourceId, sourceId);
        mapper.delete(wrapper);

        // 判断后保存信息
        if(attachmentList != null) {
            List<SfaApplyAttachmentReqVo> list =  attachmentList.stream().filter(vo ->
                StringUtils.isNotEmpty(vo.getPicUrl()) ||
                StringUtils.isNotEmpty(vo.getPicPath()) ||
                StringUtils.isNotEmpty(vo.getPicDesc())
            ).collect(Collectors.toList());
            if(list != null && list.size() > 0) {
                SfaSignApplyAttachmentEntity entity = new SfaSignApplyAttachmentEntity();
                entity.setApplyType(applyType);
                entity.setSourceId(sourceId);
                entity.setAttachmentListJson(JSON.toJSONString(list));

                save(entity);
            }
        }
    }
}
