package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.worksign.model.SfaTravelEntity;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksign.model.SfaTravelUserEntity;
import com.biz.crm.worksign.mapper.SfaTravelUserMapper;
import com.biz.crm.worksign.service.ISfaTravelUserService;
import java.util.List;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelUserRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelUserReqVo;

import javax.annotation.Resource;

/**
 * 出差人员表 接口实现
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaTravelUserServiceExpandImpl")
public class SfaTravelUserServiceImpl extends ServiceImpl<SfaTravelUserMapper, SfaTravelUserEntity> implements ISfaTravelUserService {

    @Resource
    private SfaTravelUserMapper sfaTravelUserMapper;

    /**
     * 列表
     * @param
     * @return
     */
    @Override
    public List<SfaTravelUserRespVo> findList(String travelId){
        SfaTravelUserReqVo reqVo = new SfaTravelUserReqVo();
        reqVo.setTravelId(travelId);
        return sfaTravelUserMapper.findList(null, reqVo);
    }

    /**
     * 保存出差人员列表
     * @param userReqVos
     */
    @Override
    public void saveTravelUser(List<SfaTravelUserReqVo> userReqVos, SfaTravelEntity travelEntity) {
        AssertUtils.isNotEmpty(userReqVos, "人员列表不能为空");

        // 先删除后新增
        sfaTravelUserMapper.delete(Wrappers.lambdaQuery(SfaTravelUserEntity.class).eq(SfaTravelUserEntity::getTravelId, travelEntity.getId()));
        List<SfaTravelUserEntity> entityList = userReqVos.stream().map(vo -> {
            SfaTravelUserEntity entity = CrmBeanUtil.copy(vo, SfaTravelUserEntity.class);
            entity.setTravelId(travelEntity.getId());
            return entity;
        }).collect(Collectors.toList());
        this.saveOrUpdateBatch(entityList);
    }

}
