package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeTimeInfoMapper;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeTimeInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkOvertimeTimeInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaWorkOvertimeTimeInfoServiceImpl.java
 * @Description 工作日调整日期明细 业务接口实现
 * @createTime 2020年12月17日 15:44:00
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="sfaWorkOvertimeTimeInfoServiceExpandImpl")
public class SfaWorkOvertimeTimeInfoServiceImpl extends ServiceImpl<SfaWorkOvertimeTimeInfoMapper, SfaWorkOvertimeTimeInfoEntity>
        implements ISfaWorkOvertimeTimeInfoService {

    @Resource
    private SfaWorkOvertimeTimeInfoMapper mapper;

    @Override
    public void saveTimeInfo(SfaWorkOvertimeEntity overtimeEntity) {
        // 状态为已通过
        if(SfaCommonEnum.dataBpmStatus.PASS.getValue().equals(overtimeEntity.getBpmStatus())) {
            // 获取日期明细补全数据
            List<SfaApplyTimeInfoReqVo> timeInfoList = SfaSignUtils.fillTimeInfoAndCheck(
                    JSON.parseArray(overtimeEntity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class)
                    ,overtimeEntity.getBeginTime(),overtimeEntity.getEndTime()
            );


            // 拼装成数据集合
            List<SfaWorkOvertimeTimeInfoEntity> list = new ArrayList<>();
            for(int r = 0; r < timeInfoList.size(); r ++) {
                SfaApplyTimeInfoReqVo timeInfoReqVo = timeInfoList.get(r);
                SfaWorkOvertimeTimeInfoEntity entity = new SfaWorkOvertimeTimeInfoEntity();
                entity.setOvertimeId(overtimeEntity.getId());
                entity.setUserName(overtimeEntity.getUserName());
                entity.setPosCode(overtimeEntity.getPosCode());
                entity.setOrgCode(overtimeEntity.getOrgCode());
                entity.setOrgName(overtimeEntity.getOrgName());
                entity.setOvertimeDate(timeInfoReqVo.getTimeStr());
                entity.setTimeType(timeInfoReqVo.getTimeType());
                // 判断第一条和最后一天是否已存在
                if(r == 0 || r == (timeInfoList.size() - 1)) {
                    // 判断第一条和最后一天是否已存在
                    LambdaQueryWrapper<SfaWorkOvertimeTimeInfoEntity> wrapper = new LambdaQueryWrapper<SfaWorkOvertimeTimeInfoEntity>()
                            .eq(SfaWorkOvertimeTimeInfoEntity::getUserName, overtimeEntity.getUserName())
                            .eq(SfaWorkOvertimeTimeInfoEntity::getOvertimeDate, timeInfoList.get(r).getTimeStr());
                    SfaWorkOvertimeTimeInfoEntity oldData = mapper.selectOne(wrapper);
                    if(oldData != null) {
                        entity.setId(oldData.getId());
                        entity.setTimeType(SfaCommonEnum.dataTimeType.ALL_DAY.getValue());
                    }
                }
                list.add(entity);
            }
            // 保存信息
            this.saveOrUpdateBatch(list);
        }
    }
}
