package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.mapper.SfaWorkSignPictureMapper;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignPictureRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignPictureReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 考勤照片 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name="SfaWorkSignPictureServiceExpandImpl")
public class SfaWorkSignPictureServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaWorkSignPictureMapper, SfaWorkSignPictureEntity> implements ISfaWorkSignPictureService {

    @Resource
    private SfaWorkSignPictureMapper sfaWorkSignPictureMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSignPictureRespVo> findList(SfaWorkSignPictureReqVo reqVo){
        Page<SfaWorkSignPictureRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSignPictureRespVo> list = sfaWorkSignPictureMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSignPictureRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<SfaWorkSignPictureRespVo> selectByRecordId(String wsRecordId) {
        if(StringUtils.isEmpty(wsRecordId)){
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList(sfaWorkSignPictureMapper.selectList(Wrappers
                .lambdaQuery(SfaWorkSignPictureEntity.class).eq(SfaWorkSignPictureEntity :: getWsRecordId, wsRecordId)), SfaWorkSignPictureRespVo.class);
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSignPictureRespVo
     */
    @Override
    public SfaWorkSignPictureRespVo query(SfaWorkSignPictureReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSignPictureReqVo reqVo){
        SfaWorkSignPictureEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSignPictureEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSignPictureReqVo reqVo){
        SfaWorkSignPictureEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSignPictureReqVo reqVo){
        List<SfaWorkSignPictureEntity> sfaWorkSignPictureEntities = sfaWorkSignPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignPictureEntities)){
            sfaWorkSignPictureEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignPictureEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSignPictureReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSignPictureEntity> sfaWorkSignPictureEntities = sfaWorkSignPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignPictureEntities)){
            sfaWorkSignPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignPictureEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSignPictureReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSignPictureEntity> sfaWorkSignPictureEntities = sfaWorkSignPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignPictureEntities)){
                sfaWorkSignPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignPictureEntities);
    }
}
