package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cache.util.SfaWorkSignRuleInfoUtil;
import com.biz.crm.cache.util.WorkUtil;
import com.biz.crm.checkin.mapper.SfaCheckInSignGroupReportMapper;
import com.biz.crm.checkin.model.SfaCheckInSignGroupReportEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAddSignTypeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.req.SfaSignRecordBatchReqVo;
import com.biz.crm.worksign.req.SfaSignRecordForBatchReqVo;
import com.biz.crm.worksign.resp.SfaPlaceStatusRespVo;
import com.biz.crm.worksign.resp.SfaWorkSignOtherTimeRecordRespVo;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.worksignrule.util.SignRuleUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 考勤打卡记录表 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name="SfaWorkSignRecordServiceExpandImpl")
public class SfaWorkSignRecordServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaWorkSignRecordMapper, SfaWorkSignRecordEntity> implements ISfaWorkSignRecordService {

    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;

    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    private ISfaWorkOvertimeService iSfaWorkOvertimeService;
    @Resource
    private SfaCheckInSignGroupReportMapper signGroupReportMapper;
    @Resource
    private SfaWorkSignPlaceMapper sfaWorkSignPlaceMapper;
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private SfaWorkSignRuleInfoUtil sfaWorkSignRuleInfoUtil;
    @Resource
    private ISfaWorkSignRuleService sfaWorkSignRuleService;
    @Resource
    private WorkUtil workUtil;

    /**
     * 更新考勤明细状态
     *
     * @param sfaSignRecordReqVo 增加考勤记录接收Vo
     * @return void
     * @method updateSignRecord
     * @date: 2021/2/25 15:13
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSignRecord(SfaSignRecordReqVo sfaSignRecordReqVo) {
        this.checkForUpdateSignRecord(sfaSignRecordReqVo);
        SfaWorkSignRuleEntity ruleEntity = this.sfaWorkSignRuleService.lambdaQuery().eq(SfaWorkSignRuleEntity:: getRuleCode, sfaSignRecordReqVo.getRuleCode()).one();
        if(null == ruleEntity){
            throw new BusinessException("不存在的考勤规则[" + sfaSignRecordReqVo.getRuleCode() + "]");
        }
        MdmPositionRespVo primaryPosition = PositionUtil.getPositionByCode(sfaSignRecordReqVo.getPosCode());
        //先根据账号、时间、职位、所属组织来确定到某个规则明细
        SfaWorkSignRuleInfoEntity infoEntity = sfaWorkSignRuleInfoService.getOne(Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class)
                .eq(SfaWorkSignRuleInfoEntity::getUserName, primaryPosition.getUserName())
                .eq(SfaWorkSignRuleInfoEntity::getRuleDate, sfaSignRecordReqVo.getRuleDate()));
        if(infoEntity != null){
            throw new BusinessException("已经存在考勤记录！");
        }
        infoEntity = SignRuleUtils.buildSfaWorkSignRuleInfoEntity(ruleEntity, primaryPosition, sfaSignRecordReqVo.getRuleDate());

        List<SfaWorkSignRecordEntity> recordEntities = SignRuleUtils.buildSfaWorkSignRecordEntity(infoEntity);
        Map<String, SfaAddSignTypeRespVo> sfaAddSignTypeRespVoList = sfaSignRecordReqVo.getSfaAddSignTypeRespVoList()
                .stream().collect(Collectors.toMap(SfaAddSignTypeRespVo :: getId, v -> v, (t, t2) -> t2));
        for (SfaWorkSignRecordEntity recordEntity : recordEntities) {
            String tempId = recordEntity.getSfaSignTimeId() + "@" + recordEntity.getWorkSignType();
            SfaAddSignTypeRespVo sfaAddSignTypeRespVo = sfaAddSignTypeRespVoList.get(tempId);
            if(null == sfaAddSignTypeRespVo){
                throw new BusinessException("打卡类型数据错误，请尝试重新打开页面刷新列表数据");
            }
            String workSignStatus = sfaAddSignTypeRespVo.getWorkSignStatus();
            if(SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(workSignStatus)){
                recordEntity.setWorkSignTime(recordEntity.getSfaSignTime());
            }
            recordEntity.setExceptionRemarks(sfaSignRecordReqVo.getExceptionRemarks());
            recordEntity.setWorkSignStatus(workSignStatus);
        }

        sfaWorkSignRuleInfoService.saveOrUpdate(infoEntity);
        this.saveOrUpdateBatch(recordEntities);
    }


    protected void checkForUpdateSignRecord(SfaSignRecordReqVo sfaSignRecordReqVo){
        if(StringUtils.isEmpty(sfaSignRecordReqVo.getExceptionRemarks())){
            throw new BusinessException("异常说明不能为空");
        }
        if(StringUtils.isEmpty(sfaSignRecordReqVo.getPosCode())){
            throw new BusinessException("职位编码不能为空");
        }
        if(StringUtils.isEmpty(sfaSignRecordReqVo.getRuleCode())){
            throw new BusinessException("规则编码不能为空");
        }
        List<SfaAddSignTypeRespVo> sfaAddSignTypeRespVoList = sfaSignRecordReqVo.getSfaAddSignTypeRespVoList();
        if(org.springframework.util.CollectionUtils.isEmpty(sfaAddSignTypeRespVoList)){
            throw new BusinessException("打卡类型列表不能为空");
        }
        for (SfaAddSignTypeRespVo sfaAddSignTypeRespVo : sfaAddSignTypeRespVoList) {
            if(org.apache.commons.lang3.StringUtils.isBlank(sfaAddSignTypeRespVo.getId())){
                throw new BusinessException("打卡类型ID不能为空");
            }
            if(org.apache.commons.lang3.StringUtils.isBlank(sfaAddSignTypeRespVo.getWorkSignStatus())){
                throw new BusinessException("打卡类型列表内的考勤状态不能为空");
            }
        }

    }

    /**
     * 批量修改对应id的考勤明细的考勤状态
     *
     * @return void
     * @method updateBatchList
     * @date: 2021/2/25 10:40
     * @author: YuanZiJian
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateBatchList(SfaSignRecordBatchReqVo sfaSignRecordBatchReqVo) {
        //基本校验
        if(StringUtils.isEmpty(sfaSignRecordBatchReqVo.getWorkSignStatus())||CollectionUtil.listEmpty(sfaSignRecordBatchReqVo.getSfaBatchReqVos())||StringUtils.isEmpty(sfaSignRecordBatchReqVo.getWsPlaceStatus())){
            throw new BusinessException("请确认修改考勤状态的参数是否为空");
        }
        List<SfaSignRecordForBatchReqVo> sfaBatchReqVos = sfaSignRecordBatchReqVo.getSfaBatchReqVos();
        //校验传入的打卡记录相关参数是否缺少
        sfaBatchReqVos.forEach(data->{
            if(StringUtils.isEmpty(data.getId())||StringUtils.isEmpty(data.getSfaSignTime())){
                throw  new BusinessException("id或打卡时间参数为空,ID:"+data.getId());
            }
        });
        //设置状态是未打卡时
        if(SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(sfaSignRecordBatchReqVo.getWorkSignStatus())){
            List<String> stringsId = sfaBatchReqVos.stream().map(SfaSignRecordForBatchReqVo::getId).collect(Collectors.toList());
            this.update(Wrappers.lambdaUpdate(SfaWorkSignRecordEntity.class)
                    .in(SfaWorkSignRecordEntity::getId,stringsId)
                    .set(SfaWorkSignRecordEntity::getWorkSignTime,null)
                    .set(SfaWorkSignRecordEntity::getWorkSignStatus,sfaSignRecordBatchReqVo.getWorkSignStatus())
                    .set(SfaWorkSignRecordEntity::getWsPlaceStatus,sfaSignRecordBatchReqVo.getWsPlaceStatus())
                    .set(SfaWorkSignRecordEntity::getExceptionRemarks,sfaSignRecordBatchReqVo.getExceptionRemarks()));
        }
        if(SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(sfaSignRecordBatchReqVo.getWorkSignStatus())){
            //由于是批量修改，故修改的打卡记录可能不属于同一个规则，无法批量修改，故使用循环逐一修改
            sfaBatchReqVos.forEach(data->{
                this.update(Wrappers.lambdaUpdate(SfaWorkSignRecordEntity.class)
                        .eq(SfaWorkSignRecordEntity::getId,data.getId())
                        .set(SfaWorkSignRecordEntity::getWorkSignTime,data.getSfaSignTime())
                        .set(SfaWorkSignRecordEntity::getWorkSignStatus,sfaSignRecordBatchReqVo.getWorkSignStatus())
                        .set(SfaWorkSignRecordEntity::getWsPlaceStatus,sfaSignRecordBatchReqVo.getWsPlaceStatus())
                        .set(SfaWorkSignRecordEntity::getExceptionRemarks,sfaSignRecordBatchReqVo.getExceptionRemarks()));
            });
        }
    }



    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSignRecordRespVo> findList(SfaWorkSignRecordReqVo reqVo){
        Page<SfaWorkSignRecordRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSignRecordRespVo> list = sfaWorkSignRecordMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSignRecordRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSignRecordRespVo
     */
    @Override
    public SfaWorkSignRecordRespVo query(SfaWorkSignRecordReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSignRecordReqVo reqVo){
        SfaWorkSignRecordEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSignRecordEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSignRecordReqVo reqVo){
        SfaWorkSignRecordEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSignRecordReqVo reqVo){
        List<SfaWorkSignRecordEntity> sfaWorkSignRecordEntities = sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRecordEntities)){
            sfaWorkSignRecordEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSignRecordReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSignRecordEntity> sfaWorkSignRecordEntities = sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRecordEntities)){
            sfaWorkSignRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSignRecordReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSignRecordEntity> sfaWorkSignRecordEntities = sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRecordEntities)){
                sfaWorkSignRecordEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    public List<SfaWorkSignRecordEntity> getRecordsByInfo(String signRuleInfoId, String signType) {
        LambdaQueryWrapper<SfaWorkSignRecordEntity> wrapper = Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                .eq(SfaWorkSignRecordEntity::getWsRuleInfoId, signRuleInfoId);
        if(StringUtils.isNotEmpty(signType)) {
            wrapper.eq(SfaWorkSignRecordEntity::getWorkSignType, signType);
        }
        return sfaWorkSignRecordMapper.selectList(wrapper);
    }


    /*********************************************微信端接口查询********************************************************/


    /**
     * 查询当前时间之前，打卡时是否有其他时间段的打卡明细。
     *
     * @param workSignType 查询的打卡类型
     * @param id 不查询的Id
     * @return
     */
    @Override
    public List<SfaWorkSignOtherTimeRecordRespVo> getOtherTimeRecordInfo(String workSignType, String id) {
        AssertUtils.isNotEmpty(workSignType,"打卡类型不能为空");
        AssertUtils.isNotEmpty(id,"当前的打卡id不能为空");
        UserRedis user = UserUtils.getUser();
        LocalDateTime now = LocalDateTime.now();
        String dayTimeDay = now.format(CrmDateUtils.yyyyMMdd);
        String dayTimeHours = now.format(CrmDateUtils.HHmmss);
        List<SfaWorkSignRecordEntity> recordEntities = this.list(Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                .eq(SfaWorkSignRecordEntity::getWorkSignType, workSignType)
                .eq(SfaWorkSignRecordEntity::getWsUserName, user.getUsername())
                .eq(SfaWorkSignRecordEntity::getRuleDate,dayTimeDay)
                .le(SfaWorkSignRecordEntity::getSfaSignTime,dayTimeHours)
                .ne(SfaWorkSignRecordEntity::getId, id));
        List<SfaWorkSignOtherTimeRecordRespVo> signOtherTimeRecordRespVos = CrmBeanUtil.copyList(recordEntities, SfaWorkSignOtherTimeRecordRespVo.class);
        return signOtherTimeRecordRespVos;
    }


    /**
     * 查询当前位置打卡地点是否异常
     *
     * @param clockReqVo
     * @return
     */
    @Override
    public Result<SfaPlaceStatusRespVo> getPlaceStatus(ClockReqVo clockReqVo) {
        SfaWorkSignRecordEntity sfaWorkSignRecord = this.getById(clockReqVo.getId());
        if (null == sfaWorkSignRecord){
            throw new BusinessException("考勤记录不存在:"+clockReqVo.getId());
        }
        //查询考勤明细
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity){
            throw new BusinessException("考勤明细不存在");
        }
        SfaWorkSignRuleInfoRespVo workSignRuleInfo = CrmBeanUtil.copy(workSignRuleInfoEntity, SfaWorkSignRuleInfoRespVo.class);
        if(!workSignRuleInfo.getId().equals(sfaWorkSignRecord.getWsRuleInfoId())){
            throw new BusinessException("考勤数据错误，请重试！");
        }
        sfaWorkSignRecord.setRemarks(clockReqVo.getRemarks());
        sfaWorkSignRecord.setExceptionRemarks(clockReqVo.getRemarks());
        // 校验电子围栏和注入相关信息
        this.pleaceCheck(sfaWorkSignRecord, workSignRuleInfo, clockReqVo);
        SfaPlaceStatusRespVo sfaPlaceStatusRespVo = new SfaPlaceStatusRespVo();
        if(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal().equals(sfaWorkSignRecord.getWsPlaceStatus())){
            sfaPlaceStatusRespVo.setPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal());
            sfaPlaceStatusRespVo.setMassage("考勤地点异常，请在备注填写说明！");
        }
        return Result.ok(sfaPlaceStatusRespVo);
    }
    /**
     * 上班打卡接口
     * @param clockReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result gotoWorkClock(ClockReqVo clockReqVo){
        SfaWorkSignRecordEntity sfaWorkSignRecord = this.getById(clockReqVo.getId());
        if (null == sfaWorkSignRecord){
            throw new BusinessException("考勤记录不存在:"+clockReqVo.getId());
        }
//        if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())){
//            throw new BusinessException("已完成打卡,不能重复打卡");
//        }
        boolean isClockIn = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType());
        //查询考勤明细
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity){
            throw new BusinessException("考勤明细不存在");
        }
        workSignRuleInfoEntity.checkSignTime(isClockIn, Arrays.asList(sfaWorkSignRecord));
        SfaWorkSignRuleInfoRespVo workSignRuleInfo = CrmBeanUtil.copy(workSignRuleInfoEntity, SfaWorkSignRuleInfoRespVo.class);

        if(!workSignRuleInfo.getId().equals(sfaWorkSignRecord.getWsRuleInfoId())){
            throw new BusinessException("考勤数据错误，请重试！");
        }
        //下班打卡限制校验
        this.gooffWorkSignAstrictCheck(sfaWorkSignRecord, workSignRuleInfo);
        // 拍照校验
        if (CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(workSignRuleInfo.getWsrPhotograph())
                && CollectionUtils.isEmpty(clockReqVo.getSfaWorkSignPictureReqVos())){
            throw new BusinessException("考勤照片不能为空");
        }
        sfaWorkSignRecord.setRemarks(clockReqVo.getRemarks());
        sfaWorkSignRecord.setExceptionRemarks(clockReqVo.getRemarks());
        // 校验电子围栏和注入相关信息
        this.pleaceCheck(sfaWorkSignRecord, workSignRuleInfo, clockReqVo);
        //计算考勤记录状态
        this.calculateWorkSignStatus(sfaWorkSignRecord, workSignRuleInfo);
        //注入用户信息
        this.injectUserInfo(sfaWorkSignRecord);
        // 保存信息
        this.updateById(sfaWorkSignRecord);
        //将该用户当天所有的考勤数据标记为已使用，防止已打卡的考勤数据被WEB端的手动刷新规则功能冲掉
        this.updateUsedStatus(workSignRuleInfoEntity.getId());

        List<SfaWorkSignPictureEntity> workSignPictureEntityList = clockReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = CrmBeanUtil.copy(o, SfaWorkSignPictureEntity.class);
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        //先删除后新增
        sfaWorkSignPictureService.remove(Wrappers.lambdaQuery(SfaWorkSignPictureEntity.class)
                .eq(SfaWorkSignPictureEntity::getWsRecordId,sfaWorkSignRecord.getId()));
        sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        UserRedis userRedis = UserUtils.getUser();
        String ruleDate = LocalDateTime.now().format(CrmDateUtils.yyyyMMdd);
        sfaWorkSignRuleInfoUtil.deleteKey(userRedis.getUsername(),ruleDate);
        workUtil.deleteKey(userRedis.getPoscode());
        return Result.ok(sfaWorkSignRecord);
    }

    /**
     * 将该用户当天所有的考勤数据标记为已使用，防止已打卡的考勤数据被WEB端的手动刷新规则功能冲掉
     * @param infoId
     */
    private void updateUsedStatus(String infoId){
        this.update(Wrappers.lambdaUpdate(SfaWorkSignRecordEntity.class)
                .set(SfaWorkSignRecordEntity :: getUsedStatus, YesNoEnum.yesNoEnum.YES.getValue())
                .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId, infoId));
        SfaWorkSignRuleInfoEntity infoEntityOfUpdate = new SfaWorkSignRuleInfoEntity();
        infoEntityOfUpdate.setId(infoId);
        infoEntityOfUpdate.setUsedStatus(YesNoEnum.yesNoEnum.YES.getValue());
        this.sfaWorkSignRuleInfoService.updateById(infoEntityOfUpdate);
    }

    /**
     * 查询当前登录人是否需要打卡
     *
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public NeedClock needWorkSign() {

        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity){

            return needFreeSign(new NeedClock());
        }
        List<SfaWorkSignRecordEntity> clockIn = sfaWorkSignRecordMapper.selectList(Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId,workSignRuleInfoEntity.getId())
                .eq(SfaWorkSignRecordEntity :: getWorkSignType, SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal()));
        List<SfaWorkSignRecordEntity> clockOut = sfaWorkSignRecordMapper.selectList(Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId,workSignRuleInfoEntity.getId())
                .eq(SfaWorkSignRecordEntity :: getWorkSignType, SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal()));

        //工作日
        if(YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getSignMust())){
            return needFreeSign(this.needClock(workSignRuleInfoEntity, clockIn, clockOut));
        }
        //当前考勤明细是否有工作日调整
        boolean has = this.iSfaWorkOvertimeService.hasOvertime(workSignRuleInfoEntity);
        //休息日有工作日调整，说明是加班，需要校验是否需要打卡
        if(has){
            // 工作日调整申请时无需遵循此规则
            if(YesNoEnum.yesNoEnum.NO.getValue().equals(workSignRuleInfoEntity.getNonWorkingDaySignAstrict())){
                return needFreeSign(new NeedClock());
            }
            return needFreeSign(this.needClock(workSignRuleInfoEntity, clockIn, clockOut));
        }
        //休息日无工作日调整，直接告诉前端不需要打卡
        return needFreeSign(new NeedClock());
    }

    private NeedClock needClock(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity, List<SfaWorkSignRecordEntity> clockIn, List<SfaWorkSignRecordEntity> clockOut){
        NeedClock needClock = new NeedClock();
        if(WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(workSignRuleInfoEntity.getSignOrNonType())){
            //工作日特殊日期不用打卡
            return needClock;
        }
        if(clockIn != null && clockIn.size() > 0) {
            clockIn.forEach(vo -> {
                if(SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(vo.getWorkSignStatus())) {
                    needClock.setClockIn(true);
                    needClock.setClockInNum(needClock.getClockInNum() + 1);
                }
            });
        }
        //下班无需打卡
        if(SfaWorkSignEnum.GooffWorkSignAstrictEnum.NO_SIGN.getVal().equals(workSignRuleInfoEntity.getGooffWorkSignAstrict())){
            return needClock;
        }
        if(clockOut != null && clockOut.size() > 0) {
            clockOut.forEach(vo -> {
                if(SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(vo.getWorkSignStatus())){
                    needClock.setClockOut(true);
                    needClock.setClockOutNum(needClock.getClockOutNum() + 1);
                }
            });
        }
        return needClock;
    }

    /**
     * 判断自由签到知否需要打卡
     * @param needClock
     */
    private NeedClock needFreeSign(NeedClock needClock) {
        Integer count = signGroupReportMapper.selectCount(
                Wrappers.lambdaQuery(SfaCheckInSignGroupReportEntity.class)
                .eq(SfaCheckInSignGroupReportEntity::getCheckInDate, LocalDate.now().toString())
                .eq(SfaCheckInSignGroupReportEntity::getUserName, UserUtils.getUser().getUsername())
                .eq(SfaCheckInSignGroupReportEntity::getSignStatus, SfaWorkSignEnum.WorkSignStatus.NONE.getVal())
        );
        if(count != null && count > 0) {
            needClock.setFreeSign(true);
            needClock.setFreeSignNum(count);
        }

        return needClock;
    }

    @Override
    public Boolean isFreeSignRule() {
        //获取当前登录人考勤规则明细，如果规则编码是自由时间上下班规则 则返回true
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = sfaWorkSignRuleInfoService.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity){
            return Boolean.FALSE;
        }else{
            if (SfaWorkSignEnum.WorkSignRuleType.FREE_TIME.getVal().equals(workSignRuleInfoEntity.getRuleType())){
                return Boolean.TRUE;
            }else{
                return Boolean.FALSE;
            }
        }
    }

        /**
         * 下班打卡限制
         * @param recordEntity
         * @param workSignRuleInfo
         */
    private void gooffWorkSignAstrictCheck(SfaWorkSignRecordEntity recordEntity, SfaWorkSignRuleInfoRespVo workSignRuleInfo){
        // 打卡类型为上班时，跳过验证
        if(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(recordEntity.getWorkSignType())){
            return;
        }
        //下班需要打卡，且必须打上班卡才能打下班卡
        if(SfaWorkSignEnum.GooffWorkSignAstrictEnum.GOTO_WORK_REQUIRED.getVal().equals(workSignRuleInfo.getGooffWorkSignAstrict())){
            // 获取上班签到记录,当前打卡组的上班签到记录
            SfaWorkSignRecordEntity clockIn = sfaWorkSignRecordMapper.selectOne(Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                    .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId,workSignRuleInfo.getId())
                    .eq(SfaWorkSignRecordEntity :: getSfaSignTimeId, recordEntity.getSfaSignTimeId())
                    .eq(SfaWorkSignRecordEntity :: getWorkSignType, SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal()));
            if(clockIn == null) {
                throw new BusinessException("上班打卡记录不存在");
            }
            if(SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockIn.getWorkSignStatus())){
                throw new BusinessException("未上班打卡，不能下班打卡！");
            }
        }
    }

    /**
     * 计算考勤记录状态
     * @param sfaWorkSignRecord
     * @param workSignRuleInfo
     */
    private void calculateWorkSignStatus(SfaWorkSignRecordEntity sfaWorkSignRecord, SfaWorkSignRuleInfoRespVo workSignRuleInfo){
        String ruleDate = workSignRuleInfo.getRuleDate();
        //是否是上班打卡
        boolean isClockIn = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType());
        //获取规则配置的打卡时间sfaWorkSignRecord
        String time = sfaWorkSignRecord.getSfaSignTime();
        LocalDateTime gotoTime = LocalDateTime.parse(ruleDate+" " + time, CrmDateUtils.yyyyMMddHHmmss);
        LocalDateTime localDateTime = LocalDateTime.now();
        if(SfaWorkSignEnum.WorkSignRuleType.FREE_TIME.getVal().equals(sfaWorkSignRecord.getRuleType())){
            //自由时间上下班
            sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        }else {
            if(isClockIn){
                //上班迟到
                if (localDateTime.compareTo(gotoTime) > 0 && SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal().equals(workSignRuleInfo.getRuleType())){
                    sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal());
                }else{
                    sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                }
            }else{
                //下班早退
                if (localDateTime.compareTo(gotoTime) < 0 && SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal().equals(workSignRuleInfo.getRuleType())){
                    sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.LEAVE_EARLY.getVal());
                }else{
                    sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
                }
            }
        }

        //考勤时间
        sfaWorkSignRecord.setWorkSignTime(localDateTime.format(CrmDateUtils.HHmmss));
    }
    /**
     * 注入用户信息
     * @param sfaWorkSignRecord
     */
    private void injectUserInfo(SfaWorkSignRecordEntity sfaWorkSignRecord){
        UserRedis userRedis = UserUtils.getUser();
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
    }

    /**
     * 打卡地点 ，电子围栏  待实现
     */
    private void pleaceCheck(SfaWorkSignRecordEntity sfaWorkSignRecord, SfaWorkSignRuleInfoRespVo workSignRuleInfo, ClockReqVo clockReqVo){
        sfaWorkSignRecord.setWorkSignPlace(clockReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setLngIn(clockReqVo.getLngIn());
        sfaWorkSignRecord.setLatIn(clockReqVo.getLatIn());

        String electronFence = workSignRuleInfo.getElectronFence();
        // 无电子围栏
        if(SfaWorkSignEnum.ElectronFenceEnum.NONE.getVal().equals(electronFence)) {
            return ;
        }
        // 默认打卡地点异常
        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal());
        // 允许范围外打卡，地点记录为正常
        if(SfaWorkSignEnum.ElectronFenceEnum.OUT_SIGN_OK.getVal().equals(electronFence)) {
            sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
            return;
        }
        // 打卡地点列表
        List<SfaWorkSignPlaceEntity> workSignPlaceEntities = sfaWorkSignPlaceMapper.selectList(
                Wrappers.lambdaQuery(SfaWorkSignPlaceEntity.class)
                .eq(SfaWorkSignPlaceEntity::getRuleCode,workSignRuleInfo.getRuleCode())
        );
        if (CollectionUtil.listNotEmptyNotSizeZero(workSignPlaceEntities)) {
            // 判断是否范围外
            for (SfaWorkSignPlaceEntity workSignPlace : workSignPlaceEntities){
                //判断是否是同步拜访地址
                if(WorkSignEnum.workSignPlaceType.VISIT_PLAN_PLACE.getVal().equals(workSignPlace.getPlaceName())){
                    //就去找拜访计划明细中的当天需要拜访的地址等记录
                    if (checkVisitPlanPlace(workSignPlace,clockReqVo)){
                        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
                        break;
                    }
                }
                /**地点经度 地点经度*/
                String placeLngin = workSignPlace.getPlaceLngin();
                /**地点纬度 地点纬度*/
                String placeLatin = workSignPlace.getPlaceLatin();
                /**范围*/
                String placeRange = workSignPlace.getPlaceRange();
                double placeRanged = Double.valueOf(placeRange.trim());
                if(org.apache.commons.lang3.StringUtils.isBlank(clockReqVo.getLatIn())
                        || org.apache.commons.lang3.StringUtils.isBlank(clockReqVo.getLngIn())){
                    throw new BusinessException("未获取到定位信息，请重试！");
                }
                //计算两个坐标之前的距离
                double wsDistance = DistanceUtil.GetPointDistance(clockReqVo.getLatIn() + "," + clockReqVo.getLngIn(),
                        placeLatin+","+placeLngin);
                if (wsDistance<=placeRanged){
                    sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
                    break;
                }
            }
//            // 循环结束后判断是否地点异常，若异常就需要填写异常报备
//            if(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal().equals(sfaWorkSignRecord.getWsPlaceStatus())){
//                if(StringUtils.isEmpty(sfaWorkSignRecord.getExceptionRemarks())){
//                    throw new BusinessException("地点异常，请填写异常原因备注");
//                }
//            }
        }
        // 不允许范围外打卡
        if(SfaWorkSignEnum.wsPlaceStatusEnum.EX.getVal().equals(sfaWorkSignRecord.getWsPlaceStatus())
         && SfaWorkSignEnum.ElectronFenceEnum.NO_OUT_SIGN.getVal().equals(electronFence)) {
            throw new BusinessException("不允许范围外打卡");
        }
    }

    /**
     * 校验当天拜访记录明细中的地址是否在距离范围内
     * @method checkVisitPlanPlace
     * @date: 2021/3/4 16:44
     * @author: YuanZiJian
     * @param workSignPlace
     * @param clockReqVo
     * @return boolean
     */
    private boolean checkVisitPlanPlace(SfaWorkSignPlaceEntity workSignPlace,ClockReqVo clockReqVo){
        UserRedis user = UserUtils.getUser();
        GetVisitListReq req = new GetVisitListReq();
        req.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        req.setVisitDate(LocalDateTime.now().format(CrmDateUtils.yyyyMMdd));
        req.setVisitPositionCode(user.getPoscode());
        req.setVisitUserName(user.getUsername());

        List<SfaVisitPlanInfoEntity> planInfoEntities = sfaVisitPlanInfoService.doGetVisitInfoList(req).stream()
                .filter(v -> null != v.getLongitude() && null != v.getLatitude()).collect(Collectors.toList());

        for (SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity : planInfoEntities){
            /**地点经度 地点经度*/
            String placeLngin = sfaVisitPlanInfoEntity.getLongitude().toString();
            /**地点纬度 地点纬度*/
            String placeLatin = sfaVisitPlanInfoEntity.getLatitude().toString();
            /**范围*/
            String placeRange = workSignPlace.getPlaceRange();
            double placeRanged = Double.valueOf(placeRange.trim());
            //计算两个坐标之前的距离
            double wsDistance = DistanceUtil.GetPointDistance(clockReqVo.getLatIn()+","+clockReqVo.getLngIn(),
                    placeLatin+","+placeLngin);
            if (wsDistance<=placeRanged){
               return true;
            }
        }
        return false;
    }




    /**
     * 自由签到接口
     * @param sfaWorkSignRecordReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result goFreeSignIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo){
//        Result result = new Result<>();
//        //当前时间
//        Date currentTime = new Date();
//        //当前日期
//        String currentDateStr = DateUtil.date_sdf.format(currentTime);
//        //考勤时间
//        String workSignTime = DateUtil.short_time_sdf.format(currentTime);
//        //获取当前登录人信息
//        UserRedis userRedis = UserUtils.getUser();
//        if (null==userRedis|| StringUtil.isEmpty(userRedis.getUsername())){
//            result.error401("请重新登录");
//            return result;
//        }
//        if (StringUtil.isEmpty(sfaWorkSignRecordReqVo.getFreesignCode())){
//            result.error500("请选择对应签到组");
//            return result;
//        }
//        LambdaQueryWrapper<SfaFreesignConfigEntity> freesignWrapper = new LambdaQueryWrapper<SfaFreesignConfigEntity>()
//                .eq(SfaFreesignConfigEntity::getFreesignCode,sfaWorkSignRecordReqVo.getFreesignCode());
//        List<SfaFreesignConfigEntity> freesignConfigList  = sfaFreesignConfigMapper.selectList(freesignWrapper);
//        if (!CollectionUtil.listNotEmptyNotSizeZero(freesignConfigList)){
//            result.error500("未查询到对应签到组");
//            return result;
//        }
//        SfaFreesignConfigEntity freesignConfigEntity = freesignConfigList.get(0);
//        if (StringUtil.isEmpty(sfaWorkSignRecordReqVo.getSignTypeCode())){
//            result.error500("请选择对应打卡类型");
//            return result;
//        }
//        LambdaQueryWrapper<SfaFreesignSignTypeEntity> signTypeWrapper = new LambdaQueryWrapper<SfaFreesignSignTypeEntity>()
//                .eq(SfaFreesignSignTypeEntity::getSignTypeCode,sfaWorkSignRecordReqVo.getSignTypeCode());
//        List<SfaFreesignSignTypeEntity> freesignSignTypeList  = sfaFreesignSignTypeMapper.selectList(signTypeWrapper);
//        if (!CollectionUtil.listNotEmptyNotSizeZero(freesignSignTypeList)){
//            result.error500("未查询到对应打卡类型");
//            return result;
//        }
//        SfaFreesignSignTypeEntity freesignSignTypeEntity = freesignSignTypeList.get(0);
//        if (StringUtil.isEmpty(freesignSignTypeEntity.getTimeReq())
//                && SfaCommonEnum.YesNoEnum.ONE.equals(freesignSignTypeEntity.getTimeReq())){
//            try{
//                //打卡开始时间
//                Date beginDate = DateUtil.datetimeFormat.parse(currentDateStr+" "+freesignSignTypeEntity.getBeginDate());
//                //打卡结束时间
//                Date endDate = DateUtil.datetimeFormat.parse(currentDateStr+" "+freesignSignTypeEntity.getEndDate());
//                if (currentTime.getTime()<beginDate.getTime()){
//                    result.error500("当前时间未到,该签到组【"+freesignConfigEntity.getFreesignName()+"】打卡类型【"+freesignSignTypeEntity.getSignTypeName()+"】的打卡时间");
//                    return result;
//                }
//                if (currentTime.getTime()>endDate.getTime()){
//                    result.error500("当前时间超过,该签到组【"+freesignConfigEntity.getFreesignName()+"】打卡类型【"+freesignSignTypeEntity.getSignTypeName()+"】的打卡时间");
//                    return result;
//                }
//            }catch(Exception e){
//                e.printStackTrace();
//            }
//        }
//        if (StringUtil.isEmpty(freesignSignTypeEntity.getPhotoReq())
//                && SfaCommonEnum.YesNoEnum.ONE.equals(freesignSignTypeEntity.getPhotoReq())){
//            if (CollectionUtil.listNotEmptyNotSizeZero(sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos())){
//                result.error500("打卡照片不能为空");
//                return result;
//            }
//        }
//        if (StringUtil.isEmpty(sfaWorkSignRecordReqVo.getWorkSignPlace())){
//            result.error500("考勤地点不能为空");
//            return result;
//        }
//        if (StringUtil.isEmpty(sfaWorkSignRecordReqVo.getLngIn())){
//            result.error500("签退经度不能为空");
//            return result;
//        }
//        if (StringUtil.isEmpty(sfaWorkSignRecordReqVo.getLatIn())){
//            result.error500("签退纬度不能为空");
//            return result;
//        }
//        SfaWorkSignRuleInfoEntity workSignRuleInfo = new SfaWorkSignRuleInfoEntity();
//        workSignRuleInfo.setUserName(userRedis.getUsername());
//        workSignRuleInfo.setRealName(userRedis.getRealname());
//        workSignRuleInfo.setPosCode(userRedis.getPoscode());
//        workSignRuleInfo.setPosName(userRedis.getPosname());
//        workSignRuleInfo.setOrgCode(userRedis.getOrgcode());
//        workSignRuleInfo.setOrgName(userRedis.getOrgname());
//        workSignRuleInfo.setRuleCode(freesignConfigEntity.getFreesignCode());
//        workSignRuleInfo.setRuleName(freesignConfigEntity.getFreesignName());
//        /**规则类型 规则类型*/
//        workSignRuleInfo.setRuleType(SfaWorkSignEnum.WorkSignRuleType.FREE.getVal());
//        workSignRuleInfo.setRuleType(currentDateStr);
//        if (StringUtil.isNotEmpty(freesignSignTypeEntity.getBeginDate())){
//            workSignRuleInfo.setGotoStartTime(freesignSignTypeEntity.getBeginDate());
//        }
//        if (StringUtil.isNotEmpty(freesignSignTypeEntity.getEndDate())){
//            workSignRuleInfo.setGotoEndTime(freesignSignTypeEntity.getEndDate());
//        }
//        /**电子围栏*/
//        workSignRuleInfo.setElectronFence(SfaWorkSignEnum.ElectronFenceEnum.OUT_SIGN_OK.getVal());
//        SfaWorkSignRecordEntity sfaWorkSignRecord = new SfaWorkSignRecordEntity();
//        sfaWorkSignRecord.setWorkSignType(freesignSignTypeEntity.getSignTypeCode());
//        sfaWorkSignRecord.setWorkSignDesc(freesignSignTypeEntity.getSignTypeName());
//        sfaWorkSignRecord.setWorkSignTime(workSignTime);
//        sfaWorkSignRecord.setWorkSignPlace(sfaWorkSignRecordReqVo.getWorkSignPlace());
//        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLngIn());
//        sfaWorkSignRecord.setLatIn(sfaWorkSignRecordReqVo.getLatIn());
//        /**考勤状态*/
//        sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
//        /**考勤地点状态*/
//        sfaWorkSignRecord.setWsPlaceStatus(SfaWorkSignEnum.wsPlaceStatusEnum.OK.getVal());
//        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
//        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
//        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
//        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
//        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
//        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
//        sfaWorkSignRecord.setRemarks(sfaWorkSignRecordReqVo.getRemarks());
//
//        sfaWorkSignRuleInfoService.save(workSignRuleInfo);
//        sfaWorkSignRecord.setWsRuleInfoId(workSignRuleInfo.getId());
//        this.save(sfaWorkSignRecord);
//        List<SfaWorkSignPictureEntity> workSignPictureEntityList = sfaWorkSignRecordReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
//            SfaWorkSignPictureEntity workSignPictureEntity = new SfaWorkSignPictureEntity();
//            CrmBeanUtil.copyProperties(o, workSignPictureEntity);
//            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
//            return workSignPictureEntity;
//        }).collect(Collectors.toList());
//        sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok();

    }
    /**
     * 分片批量保存
     *
     * @param recordEntityList
     */
    @Override
    public void saveBatchPartition(List<SfaWorkSignRecordEntity> recordEntityList) {
        if(CollectionUtil.listEmpty(recordEntityList)){
            return;
        }
        List<List<SfaWorkSignRecordEntity>> partitionList = Lists.partition(recordEntityList, 50);
        for(List<SfaWorkSignRecordEntity> recordEntities : partitionList){
            this.saveBatch(recordEntities);
        }
    }

    /**
     * 查询考勤历史
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaSignHistoryListRespVo> findSignHistory(SfaSignHistoryListReqVo reqVo) {
        Page<SfaSignHistoryListRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
//        // 获取人员组织机构信息
//        UserRedis userRedis = UserUtils.getUser();
////        List<String> users = new ArrayList<>();
////        users.add(userRedis.getUsername());
////
////        // 获取组织机构中下级信息
////        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
////        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
////        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(userRedis.getPoscode());
////        Result<List<MdmPositionUserOrgRespVo>> result = mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
////        if(result != null && result.getResult() != null && result.getResult().size() > 0) {
////            result.getResult().forEach(mdm -> {
////                if(StringUtils.isNotEmpty(mdm.getUserName())) {
////                    users.add(mdm.getUserName());
////                }
////            });
////        }

        List<SfaSignHistoryListRespVo> list = sfaWorkSignRecordMapper.findSignHistory(page, reqVo);
        return PageResult.<SfaSignHistoryListRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 根据ruleInfoId查询列表
     * @param ruleInfoId
     * @return
     */
    @Override
    public List<SfaWorkSignRecordEntity> findByRuleInfoId(String ruleInfoId) {
        if(StringUtils.isEmpty(ruleInfoId)) {
            return Lists.newArrayList();
        }
        List<SfaWorkSignRecordEntity> entities = this.sfaWorkSignRecordMapper.selectList(Wrappers.<SfaWorkSignRecordEntity>lambdaQuery()
        .eq(SfaWorkSignRecordEntity::getWsRuleInfoId, ruleInfoId));
        if(CollectionUtil.listEmpty(entities)) {
            return Lists.newArrayList();
        }
        return entities;
    }

    @Override
    public void deleteByDate(String ruleDate){
        sfaWorkSignRecordMapper.deleteByDate(ruleDate);
    }

}
