package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRuleInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.*;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRuleInfoMapper;
import com.biz.crm.worksign.model.NeedClock;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.cache.util.SfaWorkSignRuleInfoUtil;
import com.biz.crm.worksignrule.mapper.SfaWorkSignTimeMapper;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 考勤规则明细表 接口实现
 *
 * @author liuhongming
 * @date 2020-10-14 15:05:08
 */
@Slf4j
@Service
@Transactional
@ConditionalOnMissingBean(name="SfaWorkSignRuleInfoServiceExpandImpl")
public class SfaWorkSignRuleInfoServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaWorkSignRuleInfoMapper, SfaWorkSignRuleInfoEntity> implements ISfaWorkSignRuleInfoService {

    @Resource
    private SfaWorkSignRuleInfoMapper sfaWorkSignRuleInfoMapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private SfaWorkSignTimeMapper sfaWorkSignTimeMapper;
    @Resource
    private ISfaWorkOvertimeService iSfaWorkOvertimeService;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Resource
    private SfaApprovalService sfaApprovalService;
    @Autowired
    private SfaWorkSignRuleInfoUtil sfaWorkSignRuleInfoUtil;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSignRuleInfoRespVo> findList(SfaWorkSignRuleInfoReqVo reqVo){
        Page<SfaWorkSignRuleInfoRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSignRuleInfoRespVo> list = sfaWorkSignRuleInfoMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSignRuleInfoRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSignRuleInfoRespVo
     */
    @Override
    public SfaWorkSignRuleInfoRespVo query(SfaWorkSignRuleInfoReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSignRuleInfoReqVo reqVo){
        SfaWorkSignRuleInfoEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSignRuleInfoEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSignRuleInfoReqVo reqVo){
        SfaWorkSignRuleInfoEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
        //删除缓存
        if(entity != null) {
            sfaWorkSignRuleInfoUtil.deleteKey(entity.getUserName(), entity.getRuleDate());
        }
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSignRuleInfoReqVo reqVo){
        List<SfaWorkSignRuleInfoEntity> sfaWorkSignRuleInfoEntities = sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRuleInfoEntities)){
            sfaWorkSignRuleInfoEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
        //删除缓存
        if(CollectionUtil.listNotEmpty(sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(entity -> sfaWorkSignRuleInfoUtil.deleteKey(entity.getUserName(), entity.getRuleDate()));
        }
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSignRuleInfoReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSignRuleInfoEntity> sfaWorkSignRuleInfoEntities = sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRuleInfoEntities)){
            sfaWorkSignRuleInfoEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
        //删除缓存
        if(CollectionUtil.listNotEmpty(sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(entity -> sfaWorkSignRuleInfoUtil.deleteKey(entity.getUserName(), entity.getRuleDate()));
        }
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSignRuleInfoReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSignRuleInfoEntity> sfaWorkSignRuleInfoEntities = sfaWorkSignRuleInfoMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSignRuleInfoEntities)){
                sfaWorkSignRuleInfoEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSignRuleInfoEntities);
        //删除缓存
        if(CollectionUtil.listNotEmpty(sfaWorkSignRuleInfoEntities)) {
            sfaWorkSignRuleInfoEntities.forEach(entity -> sfaWorkSignRuleInfoUtil.deleteKey(entity.getUserName(), entity.getRuleDate()));
        }
    }

    /**
     * 查询考勤明细报表列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(SfaWorkSignInfoReqVo reqVo){
        Page<SfaWorkSignInfoRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSignInfoRespVo> list = sfaWorkSignRuleInfoMapper.findWorkSignInfoList(page, reqVo);
        return PageResult.<SfaWorkSignInfoRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }



    /*********************************************微信端接口查询********************************************************/

//    /**
//     * 查询当前登录人 当天 对应打卡规则详情
//     * @return
//     */
//    @Override
//    public SfaWorkSignRecordRespVo fingGotoWorkClockIn(String signType){
//        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock();
//        if (null == workSignRuleInfoEntity){
//            throw new BusinessException("今日无需签到");
//        }
//
//        List<SfaWorkSignRecordEntity> sfaWorkSignRecords = sfaWorkSignRecordMapper.selectList(
//                Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
//                .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId,workSignRuleInfoEntity.getId())
//                .eq(SfaWorkSignRecordEntity :: getWorkSignType, SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal()));
//        if (null == sfaWorkSignRecords || sfaWorkSignRecords.size() == 0 || sfaWorkSignRecords.get(0) == null){
//            throw new BusinessException("今日无需签到");
//        }
//        //获取当前匹配的打卡记录
//        SfaWorkSignRecordEntity sfaWorkSignRecord = workSignRuleInfoEntity.checkSignTime(true, sfaWorkSignRecords);
//        return this.buildSfaWorkSignRecordRespVo(workSignRuleInfoEntity, sfaWorkSignRecord);
//    }

    /**
     *
     * @param workSignRuleInfoEntity
     * @param sfaWorkSignRecord
     * @return
     */
    private SfaWorkSignRecordRespVo buildSfaWorkSignRecordRespVo(SfaWorkSignRuleInfoEntity workSignRuleInfoEntity, SfaWorkSignRecordEntity sfaWorkSignRecord){
        SfaWorkSignRecordRespVo workSignRecordRespVo = CrmBeanUtil.copy(sfaWorkSignRecord, SfaWorkSignRecordRespVo.class);

        /**
         * 不要获取最新的规则，打卡明细一旦生成，就与最新的考勤规则无关了
         */
        // 获取打卡时间规则
//        SfaWorkSignTimeEntity sfaWorkSignTimeEntity = sfaWorkSignTimeMapper.selectOne(
//                Wrappers.lambdaQuery(SfaWorkSignTimeEntity.class).eq(SfaWorkSignTimeEntity::getId, sfaWorkSignRecord.getSfaSignTimeId())
//        );

        String signRuleTime = sfaWorkSignRecord.getSfaSignTime();
        String signRuleStartTime = sfaWorkSignRecord.getSfaSignTimeBegin();
        String signRuleEndTime = sfaWorkSignRecord.getSfaSignTimeEnd();

        if(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType())){
            workSignRecordRespVo.setGotoTime(signRuleTime);
            workSignRecordRespVo.setGotoStartTime(signRuleStartTime);
            workSignRecordRespVo.setGotoEndTime(signRuleEndTime);
        }else{
            workSignRecordRespVo.setGooffTime(signRuleTime);
            workSignRecordRespVo.setGooffStartTime(signRuleStartTime);
            workSignRecordRespVo.setGooffEndTime(signRuleEndTime);
        }

        workSignRecordRespVo.setRuleDate(workSignRuleInfoEntity.getRuleDate());
        workSignRecordRespVo.setWsrPhotograph(workSignRuleInfoEntity.getWsrPhotograph());
        workSignRecordRespVo.setSfaWorkSignPictureRespVos(this.sfaWorkSignPictureService.selectByRecordId(sfaWorkSignRecord.getId()));

        //工作日
        if(YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getSignMust())){
            if(WorkSignEnum.signOrNonType.SPECIAL_DAY_NO_SIGN.getValue().equals(workSignRuleInfoEntity.getSignOrNonType())){
                //配置了工作日特殊日期不用打卡, 所以不用以工作日进行打卡操作
                workSignRecordRespVo.setExecuteAsWorkingDay(false);
                return workSignRecordRespVo;
            }
            workSignRecordRespVo.setExecuteAsWorkingDay(true);
            return workSignRecordRespVo;
        }
        boolean has = this.iSfaWorkOvertimeService.hasOvertime(workSignRuleInfoEntity);
        //休息日有工作日调整申请
        if(has){
            // 工作日调整申请时需要遵循此规则
            if(YesNoEnum.yesNoEnum.YES.getValue().equals(workSignRuleInfoEntity.getNonWorkingDaySignAstrict())){
                workSignRecordRespVo.setExecuteAsWorkingDay(true);
                return workSignRecordRespVo;
            }
        }
        workSignRecordRespVo.setExecuteAsWorkingDay(false);
        return workSignRecordRespVo;
    }


    /**
     * 查询考勤明细
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public SfaWorkSignRuleInfoEntity loadRuleInfoForClock(){
        //获取当前登录人信息
        UserRedis userRedis = UserUtils.getUser();
        String username = userRedis.getUsername();
//        //获取当前日期
        String ruleDate = LocalDateTime.now().format(CrmDateUtils.yyyyMMdd);
//        //查询考勤规则明细
//        LambdaQueryWrapper<SfaWorkSignRuleInfoEntity> wrapper = new LambdaQueryWrapper<SfaWorkSignRuleInfoEntity>()
//                .eq(SfaWorkSignRuleInfoEntity::getUserName,username).eq(SfaWorkSignRuleInfoEntity::getRuleDate,ruleDate);
//        SfaWorkSignRuleInfoEntity sfaWorkSignRuleInfo  = sfaWorkSignRuleInfoMapper.selectOne(wrapper);
//
//        return sfaWorkSignRuleInfo;
        SfaWorkSignRuleInfoEntity sfaWorkSignRuleInfoEntity = sfaWorkSignRuleInfoUtil.getObj(username,ruleDate);
        if(sfaWorkSignRuleInfoEntity==null||StringUtils.isEmpty(sfaWorkSignRuleInfoEntity.getUserName())){
            return null;
        }else {
            return sfaWorkSignRuleInfoEntity;
        }

    }

    /**
     * 获取当前时间考勤签到信息
     * @param signType 打卡类型
     * @return
     */
    @Override
    public SfaWorkSignRecordRespVo findSignRecordByNow(SfaWorkSignEnum.WorkSignType signType) {
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock();
        if (null == workSignRuleInfoEntity||CollectionUtil.listEmpty(workSignRuleInfoEntity.getSfaWorkSignRecords())){
            throw new BusinessException("今日无需签到");
        }

        // 打卡记录信息
        /**
        List<SfaWorkSignRecordEntity> sfaWorkSignRecords = sfaWorkSignRecordMapper.selectList(
                Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                        .eq(SfaWorkSignRecordEntity :: getWsRuleInfoId,workSignRuleInfoEntity.getId())
                        .eq(SfaWorkSignRecordEntity :: getWorkSignType, signType.getVal()));
        **/
        List<SfaWorkSignRecordEntity> sfaWorkSignRecords = new ArrayList<>();
        for(SfaWorkSignRecordEntity entity : workSignRuleInfoEntity.getSfaWorkSignRecords()){
            if(signType.getVal().equals(entity.getWorkSignType())){
                sfaWorkSignRecords.add(entity);
            }
        }

        if (CollectionUtil.listEmpty(sfaWorkSignRecords)){
            throw new BusinessException("今日无需签到");
        }
        //获取当前匹配的打卡记录
        SfaWorkSignRecordEntity sfaWorkSignRecord = workSignRuleInfoEntity.checkSignTime(signType.equals(SfaWorkSignEnum.WorkSignType.CLOCK_IN), sfaWorkSignRecords);
        return this.buildSfaWorkSignRecordRespVo(workSignRuleInfoEntity, sfaWorkSignRecord);
    }

    /**
     * 获取工作台页面——所有的气泡和通知
     *
     * @return com.biz.crm.moblie.controller.workbench.resp.SfaNoticeRespVo
     * @method getAllNotice
     * @date: 2021/3/15 11:04
     * @author: YuanZiJian
     */
    @Override
    public SfaNoticeRespVo getAllNoticeRedis() {
        NeedClock needClock = sfaWorkSignRecordService.needWorkSign();
        Result<Long> result = sfaApprovalService.countApproving();
        SfaNoticeRespVo sfaNoticeRespVo = new SfaNoticeRespVo();
        return sfaNoticeRespVo.setNeedClock(needClock).setApproval(result.getResult());
    }

//    /**
//     * 查询当前登录人 当前时间下班签退
//     * @return
//     */
//    @Override
//    public SfaWorkSignRecordRespVo fingGooffWorkSignOut(){
//        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.loadRuleInfoForClock();
//        if (null == workSignRuleInfoEntity){
//            throw new BusinessException("今日无需签退");
//        }
//        Map<String, SfaWorkSignRecordEntity> sfaWorkSignRecordEntities = sfaWorkSignRecordMapper
//                .selectList(Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId,workSignRuleInfoEntity.getId()))
//                .stream().collect(Collectors.toMap(SfaWorkSignRecordEntity::getWorkSignType, v -> v, (t, t2) -> t2));
//
//        SfaWorkSignRecordEntity clockOut = sfaWorkSignRecordEntities.get(SfaWorkSignEnum.WorkSignType.CLOCK_OUT.getVal());
//        if (null == clockOut){
//            throw new BusinessException("今日无需签退");
//        }
//        //没有打卡时，校验时间范围
//        if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockOut.getWorkSignStatus())){
//            workSignRuleInfoEntity.checkSignTime(false);
//        }
//        SfaWorkSignRecordEntity clockIn = sfaWorkSignRecordEntities.get(SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal());
//
//        //下班打卡限制
//        String end = StringUtils.isBlank(workSignRuleInfoEntity.getGotoEndTime()) ? CrmDateUtils.TIME_STR_12 : workSignRuleInfoEntity.getGotoEndTime();
//        if(SfaWorkSignEnum.GooffWorkSignAstrictEnum.GOTO_WORK_REQUIRED.getVal().equals(workSignRuleInfoEntity.getGooffWorkSignAstrict())
//                // 当前时间还未超过上班打卡结束时间，才能限制
//                && LocalTime.now().compareTo(LocalTime.parse(end, CrmDateUtils.HHmmss)) < 0){
//
//            if(null == clockIn || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockIn.getWorkSignStatus())){
//                throw new BusinessException("未上班打卡，不能下班打卡！");
//            }
//
//        }
//        return this.buildSfaWorkSignRecordRespVo(workSignRuleInfoEntity, clockOut);
//    }

    /**
     * 分片批量保存
     *
     * @param infoEntityList
     */
    @Override
    public void saveBatchPartition(List<SfaWorkSignRuleInfoEntity> infoEntityList) {
        if(CollectionUtil.listEmpty(infoEntityList)){
            return;
        }
        List<List<SfaWorkSignRuleInfoEntity>> partitionList = Lists.partition(infoEntityList, 50);
        for(List<SfaWorkSignRuleInfoEntity> infoEntities : partitionList){
            this.saveBatch(infoEntities);
        }
    }

    /**
     * 根据用户名和打卡日期查询
     * @param userName
     * @param ruleDate
     * @return
     */
    @Override
    public SfaWorkSignRuleInfoEntity findByUserNameAndRuleDate(String userName, String ruleDate) {
        if(StringUtils.isEmpty(userName) || StringUtils.isEmpty(ruleDate)) {
            return null;
        }
        SfaWorkSignRuleInfoEntity infoEntity = this.sfaWorkSignRuleInfoMapper.selectOne(new LambdaQueryWrapper<SfaWorkSignRuleInfoEntity>()
                .eq(SfaWorkSignRuleInfoEntity::getUserName, userName)
                .eq(SfaWorkSignRuleInfoEntity::getRuleDate, ruleDate));
        if(infoEntity == null) {
            return null;
        }
        List<SfaWorkSignRecordEntity> recordEntities = sfaWorkSignRecordService.findByRuleInfoId(infoEntity.getId());
        infoEntity.setSfaWorkSignRecords(recordEntities);
        return infoEntity;
    }


}
