package com.biz.crm.worksignrule.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 考勤规则-打卡人员 
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignpersonnel")
@Api(tags = "考勤规则-打卡人员 ")
public class SfaWorkSignPersonnelController {
    @Autowired
    private ISfaWorkSignPersonnelService sfaWorkSignPersonnelService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignPersonnelRespVo>> list(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        PageResult<SfaWorkSignPersonnelRespVo> result=sfaWorkSignPersonnelService.findList(sfaWorkSignPersonnelReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignPersonnelRespVo> query(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        SfaWorkSignPersonnelRespVo respVo=sfaWorkSignPersonnelService.query(sfaWorkSignPersonnelReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        sfaWorkSignPersonnelService.save(sfaWorkSignPersonnelReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        sfaWorkSignPersonnelService.update(sfaWorkSignPersonnelReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        sfaWorkSignPersonnelService.deleteBatch(sfaWorkSignPersonnelReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        sfaWorkSignPersonnelService.enableBatch(sfaWorkSignPersonnelReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
        sfaWorkSignPersonnelService.disableBatch(sfaWorkSignPersonnelReqVo);
        return Result.ok("禁用成功");
    }
}
