package com.biz.crm.worksignrule.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksignrule.service.ISfaWorkSignPlaceService;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPlaceRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPlaceReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 考勤规则-打卡地点 
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignplace")
@Api(tags = "考勤规则-打卡地点 ")
public class SfaWorkSignPlaceController {
    @Autowired
    private ISfaWorkSignPlaceService sfaWorkSignPlaceService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignPlaceRespVo>> list(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        PageResult<SfaWorkSignPlaceRespVo> result=sfaWorkSignPlaceService.findList(sfaWorkSignPlaceReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignPlaceRespVo> query(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        SfaWorkSignPlaceRespVo respVo=sfaWorkSignPlaceService.query(sfaWorkSignPlaceReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        sfaWorkSignPlaceService.save(sfaWorkSignPlaceReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        sfaWorkSignPlaceService.update(sfaWorkSignPlaceReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        sfaWorkSignPlaceService.deleteBatch(sfaWorkSignPlaceReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        sfaWorkSignPlaceService.enableBatch(sfaWorkSignPlaceReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignPlaceReqVo sfaWorkSignPlaceReqVo) {
        sfaWorkSignPlaceService.disableBatch(sfaWorkSignPlaceReqVo);
        return Result.ok("禁用成功");
    }
}
