package com.biz.crm.worksignrule.controller;

import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleExcuteByIdRqeVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksignrule.service.ISfaWorkSignPersonnelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksignrule.service.ISfaWorkSignRuleService;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

import java.time.LocalDate;
import java.util.List;

/**
 * 考勤规则;考勤规则
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksignrule")
@Api(tags = "后台-考勤管理-考勤规则")
public class SfaWorkSignRuleController {
    @Autowired
    private ISfaWorkSignRuleService sfaWorkSignRuleService;
    @Autowired
    private ISfaWorkSignPersonnelService personnelService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaWorkSignRuleRespVo>> list(@RequestBody SfaWorkSignRuleVo sfaWorkSignRuleVo) {
        PageResult<SfaWorkSignRuleRespVo> result=sfaWorkSignRuleService.findList(sfaWorkSignRuleVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignRuleRespVo> query(@RequestBody SfaWorkSignRuleExcuteByIdRqeVo idRqeVo) {

        AssertUtils.isNotEmpty(idRqeVo.getId(), "请选择规则");

        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setId(idRqeVo.getId());
//        SfaWorkSignRuleRespVo respVo=sfaWorkSignRuleService.query(sfaWorkSignRuleReqVo);
        SfaWorkSignRuleRespVo respVo=sfaWorkSignRuleService.findDetailsById(idRqeVo.getId());
        return Result.ok(respVo);
    }

    @ApiOperation(value = "已设置考勤规则的组织列表")
    @PostMapping("/getAlreadySetOrgList")
    @CrmLog
    public Result<List<SfaWorkSignPersonnelRespVo>> getAlreadySetOrgList(@RequestBody(required = false) String ruleCode) {
        List<SfaWorkSignPersonnelRespVo> list = personnelService.findListJoinRule(null, ruleCode, null, CrmEnableStatusEnum.ENABLE.getCode());
        return Result.ok(list);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
        sfaWorkSignRuleService.save(sfaWorkSignRuleReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
        sfaWorkSignRuleService.update(sfaWorkSignRuleReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        sfaWorkSignRuleService.deleteBatch(sfaWorkSignRuleReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {

        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        sfaWorkSignRuleService.enableBatch(sfaWorkSignRuleReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {

        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setIds(ids);
        sfaWorkSignRuleService.disableBatch(sfaWorkSignRuleReqVo);
        return Result.ok("禁用成功");
    }

    /**
     * 执行考勤规则
     */
    @ApiOperation(value = "执行考勤规则，生成指定日期的考勤数据")
    @PostMapping("/executeWorkSignRule")
    @CrmLog
    public Result executeWorkSignRule(@RequestBody SfaWorkSignExecuteReqVo reqVo) {
        // 默认当天
        if(StringUtils.isEmpty(reqVo.getExecuteDate())) {
            reqVo.setExecuteDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        }
        this.doExecuteWorkSignRule(reqVo);

        return Result.ok("刷新任务提交成功，请稍后核对数据！");
    }
    @Async
    protected void doExecuteWorkSignRule(SfaWorkSignExecuteReqVo reqVo){
        sfaWorkSignRuleService.executeWorkSignRule(reqVo);
    }
}
