package com.biz.crm.worksignrule.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.worksignrule.service.ISfaWorkSignTimeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考勤规则-打卡时间;
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@RestController
@RequestMapping("/sfaworksigntime")
@Api(tags = "考勤规则-打卡时间;")
public class SfaWorkSignTimeController {
    @Autowired
    private ISfaWorkSignTimeService sfaWorkSignTimeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSignTimeRespVo>> list(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        PageResult<SfaWorkSignTimeRespVo> result=sfaWorkSignTimeService.findList(sfaWorkSignTimeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSignTimeRespVo> query(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        SfaWorkSignTimeRespVo respVo=sfaWorkSignTimeService.query(sfaWorkSignTimeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        sfaWorkSignTimeService.save(sfaWorkSignTimeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        sfaWorkSignTimeService.update(sfaWorkSignTimeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        sfaWorkSignTimeService.deleteBatch(sfaWorkSignTimeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        sfaWorkSignTimeService.enableBatch(sfaWorkSignTimeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo) {
        sfaWorkSignTimeService.disableBatch(sfaWorkSignTimeReqVo);
        return Result.ok("禁用成功");
    }
}
