package com.biz.crm.worksignrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;


/**
 * 考勤规则-打卡人员 实体类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_personnel")
@CrmTable(name = "sfa_work_sign_personnel" , tableNote = "考勤人员", indexes = {
        @Index(name = "sfa_work_sign_personnel_index1",columnList ="wsp_code, code_type" ),
        @Index(name = "sfa_work_sign_personnel_index2",columnList ="rule_code" )
})
public class SfaWorkSignPersonnelEntity extends CrmExtTenEntity<SfaWorkSignPersonnelEntity> {

    /**
     * 组织编码 组织编码
     */
    @CrmColumn(name = "wsp_code", length = 32, note = "组织编码 组织编码")
    private String wspCode;

    /**
     * 组织名称 组织
     */
    @CrmColumn(name = "wsp_name", length = 100, note = "组织名称 组织")
    private String wspName;

    /**
     * 是否当前组织(Y:当前组织;N:当前组织及下级组织)
     */
    @CrmColumn(name = "current_able", length = 64, note = "是否当前组织(Y:当前组织;N:当前组织及下级组织)")
    private String currentAble;


    /**
     * 规则编码;规则编码
     */
    @CrmColumn(name = "rule_code", length = 32, note = "规则编码;规则编码")
    private String ruleCode;

    @CrmColumn(name = "code_type" , length = 10)
    private String codeType;

}
