package com.biz.crm.worksignrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 特殊日期 实体类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_special")
@CrmTable(name = "sfa_work_sign_special", tableNote = "特殊日期")
public class SfaWorkSignSpecialEntity extends CrmExtTenEntity<SfaWorkSignSpecialEntity> {
    /**
     * 类型 (1:必须打卡的日期;2:不用打卡的日期)
     */
    @CrmColumn(name = "wss_type", length = 32, note = "类型 (1:必须打卡的日期;2:不用打卡的日期)")
    private String wssType;

    /**
     * 日期 日期
     */
    @CrmColumn(name = "wss_date", length = 32, note = "日期 日期")
    private String wssDate;

    /**
     * 规则编码;规则编码
     */
    @CrmColumn(name = "rule_code", length = 32, note = "规则编码;规则编码")
    private String ruleCode;
}
