package com.biz.crm.worksignrule.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 考勤规则-打卡时间;实体类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_sign_time")
@CrmTable(name = "sfa_work_sign_time", tableNote = "考勤规则-打卡时间;")
public class SfaWorkSignTimeEntity extends CrmExtTenEntity<SfaWorkSignTimeEntity> {

    /**
     * 序号;序号
     */
    @CrmColumn(name = "wst_no", length = 32, note = "序号;序号")
    private String wstNo;

    /**
     * 上班打卡时间;上班时间
     */
    @CrmColumn(name = "goto_time", length = 32, note = "上班打卡时间;上班时间")
    private String gotoTime;

    /**
     * 下班打卡时间;下班时间
     */
    @CrmColumn(name = "gooff_time", length = 32, note = "下班打卡时间;下班时间")
    private String gooffTime;

    /**
     * 上班打卡开始时间;打卡时间限制-可打上班卡开始时间
     */
    @CrmColumn(name = "goto_start_time", length = 32, note = "上班打卡开始时间;打卡时间限制-可打上班卡开始时间")
    private String gotoStartTime;

    /**
     * 上班打卡结束时间;打卡时间限制-可打上班卡结束时间
     */
    @CrmColumn(name = "goto_end_time", length = 32, note = "上班打卡结束时间;打卡时间限制-可打上班卡结束时间")
    private String gotoEndTime;

    /**
     * 下班打卡开始时间;打卡时间限制-可打下班卡开始时间
     */
    @CrmColumn(name = "gooff_start_time", length = 32, note = "下班打卡开始时间;打卡时间限制-可打下班卡开始时间")
    private String gooffStartTime;

    /**
     * 下班打卡结束时间;打卡时间限制-可打下班卡结束时间
     */
    @CrmColumn(name = "gooff_end_time", length = 32, note = "下班打卡结束时间;打卡时间限制-可打下班卡结束时间")
    private String gooffEndTime;

    /**
     * 规则编码;规则编码
     */
    @CrmColumn(name = "rule_code", length = 32, note = "规则编码;规则编码")
    private String ruleCode;
}
