package com.biz.crm.worksignrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.vo.ExecuteWorkSignRuleVo;

/**
 * 考勤规则;考勤规则接口
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
public interface ISfaWorkSignRuleService extends IService<SfaWorkSignRuleEntity> {

    /**
     * 列表
     * @param  sfaWorkSignRuleVo
     * @return PageResult<SfaWorkSignRuleRespVo>
     */
    PageResult<SfaWorkSignRuleRespVo> findList(SfaWorkSignRuleVo sfaWorkSignRuleVo);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    SfaWorkSignRuleRespVo findDetailsById(String id);

    /**
     * 查询
     * @param sfaWorkSignRuleReqVo
     * @return SfaWorkSignRuleRespVo
     */
    SfaWorkSignRuleRespVo query(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 新增
     * @param sfaWorkSignRuleReqVo
     * @return
     */
    void save(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 更新
     * @param sfaWorkSignRuleReqVo
     * @return
     */
    void update(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 删除
     * @param sfaWorkSignRuleReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 启用
     * @param sfaWorkSignRuleReqVo
     * @return
     */
    void enableBatch(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 禁用
     * @param sfaWorkSignRuleReqVo
     * @return
     */
    void disableBatch(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo);

    /**
     * 执行考勤规则，生成指定日期的明细
     * @param reqVo
     */
    @Deprecated
    void executeWorkSignRule(SfaWorkSignExecuteReqVo reqVo);

    /**
     * 生成考勤明细
     * @param executeWorkSignRuleVo
     */
    void executeWorkSignRule(ExecuteWorkSignRuleVo executeWorkSignRuleVo);



    /**
     * 根据组织编码获取考勤信息
     * @param orgCode
     * @return
     */
    SfaWorkSignRuleRespVo getSignRuleByOrgCode(String orgCode);

    /**
     * 根据考勤规则构建并保存打卡信息
     * @param rule
     * @param userName
     * @param executeDate
     */
    SfaWorkSignRuleInfoEntity buildAndSaveSignRuleInfo(SfaWorkSignRuleEntity rule, String userName, String executeDate);
}

