package com.biz.crm.worksignrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignSpecialReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 特殊日期 接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
public interface ISfaWorkSignSpecialService extends IService<SfaWorkSignSpecialEntity> {

    /**
     * 列表
     * @param sfaWorkSignSpecialReqVo
     * @return PageResult<SfaWorkSignSpecialRespVo>
     */
    PageResult<SfaWorkSignSpecialRespVo> findList(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);
    /**
     * 根据规则编码查询 Mapping 列表
     * @param ruleCodes
     * @return
     */
    Map<String, List<SfaWorkSignSpecialEntity>> selectMappingByRuleCodes(Set<String> ruleCodes);
    /**
     * 不分页列表
     */
    List<SfaWorkSignSpecialRespVo> findNonPageList(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 查询
     * @param sfaWorkSignSpecialReqVo
     * @return SfaWorkSignSpecialRespVo
     */
    SfaWorkSignSpecialRespVo query(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 新增
     * @param sfaWorkSignSpecialReqVo
     * @return
     */
    void save(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 更新
     * @param sfaWorkSignSpecialReqVo
     * @return
     */
    void update(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 删除
     * @param sfaWorkSignSpecialReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 启用
     * @param sfaWorkSignSpecialReqVo
     * @return
     */
    void enableBatch(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 禁用
     * @param sfaWorkSignSpecialReqVo
     * @return
     */
    void disableBatch(SfaWorkSignSpecialReqVo sfaWorkSignSpecialReqVo);

    /**
     * 根据考勤规则编码和考勤日期查询特殊日期记录
     * 注：如果参数为空，则返回空，或者抛异常 TODO 待定
     * @param ruleCode
     * @param wssDate
     * @return
     */
    SfaWorkSignSpecialEntity findByRuleCodeAndWssDate(String ruleCode, String wssDate);
}

