package com.biz.crm.worksignrule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignTimeReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignTimeRespVo;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 考勤规则-打卡时间;接口
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
public interface ISfaWorkSignTimeService extends IService<SfaWorkSignTimeEntity> {

    /**
     * 列表
     * @param sfaWorkSignTimeReqVo
     * @return PageResult<SfaWorkSignTimeRespVo>
     */
    PageResult<SfaWorkSignTimeRespVo> findList(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);
    /**
     * 根据规则编码查询 Mapping 列表
     * @param ruleCodes
     * @return
     */
    Map<String, List<SfaWorkSignTimeEntity>> selectMappingByRuleCodes(Set<String> ruleCodes);
    /**
     * 查询
     * @param sfaWorkSignTimeReqVo
     * @return SfaWorkSignTimeRespVo
     */
    SfaWorkSignTimeRespVo query(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 新增
     * @param sfaWorkSignTimeReqVo
     * @return
     */
    void save(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 更新
     * @param sfaWorkSignTimeReqVo
     * @return
     */
    void update(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 删除
     * @param sfaWorkSignTimeReqVo
     * @return
     */
    void deleteBatch(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 启用
     * @param sfaWorkSignTimeReqVo
     * @return
     */
    void enableBatch(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 禁用
     * @param sfaWorkSignTimeReqVo
     * @return
     */
    void disableBatch(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 新增,编辑,校验
     * @param sfaWorkSignTimeReqVo
     */
    void saveCheck(SfaWorkSignTimeReqVo sfaWorkSignTimeReqVo);

    /**
     * 根据规则编码查询列表
     * @param ruleCode
     * @return
     */
    List<SfaWorkSignTimeEntity> findByRuleCode(String ruleCode);
}

