package com.biz.crm.worksignrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Component
@ConditionalOnMissingBean(name = "signRuleResolveHelperExtend")
public class SignRuleResolveHelper {
    @Resource
    protected ISfaWorkSignRuleInfoService iSfaWorkSignRuleInfoService;
    @Resource
    protected ISfaWorkSignRecordService iSfaWorkSignRecordService;
    /**
     * 保存考勤规则
     * @param context
     */
    @Transactional
    public void saveSignRuleInfo(String baseExecuteDate, ExecuteSignRuleContext context) {
//        Set<String> ruleCodes = context.getRules().stream().map(SfaWorkSignRuleEntity::getId).collect(Collectors.toSet());
        //删除之前生成的记录,并将context内无法删除的记录移除
        this.delInfoAndRecord(context, baseExecuteDate);
        try {
            // 保存考勤明细
            this.iSfaWorkSignRuleInfoService.saveBatchPartition(context.getRuleInfoEntities());
            // 保存打卡明细
            this.iSfaWorkSignRecordService.saveBatchPartition(context.getRecordEntities());
        }catch (DuplicateKeyException e){
            String msg = "保存考勤数据失败[" + e.getCause().getMessage() + "]";
            log.error(msg, e);
            throw new BusinessException(msg, e);
        }

    }
    /**
     * 删除之前生成的记录，并将context内无法删除的记录移除
     * @param ruleDate
     */
    protected void delInfoAndRecord(ExecuteSignRuleContext context, String ruleDate){

        //删除之前生成的记录
        this.doDelInfoAndRecord(ruleDate);
        //将context内无法删除的记录移除，防止写入数据库时唯一键异常
        this.removeNotDel(context, ruleDate);
    }


    protected void doDelInfoAndRecord(String ruleDate){
        //创建删除info Wrapper
        LambdaQueryWrapper<SfaWorkSignRuleInfoEntity> lambdaQueryWrapperOfInfo = Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class)
                .ge(SfaWorkSignRuleInfoEntity :: getRuleDate, ruleDate)
                .ge(SfaWorkSignRuleInfoEntity :: getRuleDate, LocalDate.now().format(CrmDateUtils.yyyyMMdd));
//        if(!org.springframework.util.CollectionUtils.isEmpty(ruleCodes)){
//            lambdaQueryWrapperOfInfo.in(SfaWorkSignRuleInfoEntity :: getRuleCode, ruleCodes);
//        }
        //创建删除record Wrapper
        LambdaQueryWrapper<SfaWorkSignRecordEntity> lambdaQueryWrapperOfRecord = Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class)
                .ge(SfaWorkSignRecordEntity :: getRuleDate, ruleDate)
                .ge(SfaWorkSignRecordEntity :: getRuleDate, LocalDate.now().format(CrmDateUtils.yyyyMMdd));
//        if(!org.springframework.util.CollectionUtils.isEmpty(ruleCodes)){
//            lambdaQueryWrapperOfRecord.in(SfaWorkSignRecordEntity :: getRuleCode, ruleCodes);
//        }
        //只删未使用过的数据
        lambdaQueryWrapperOfInfo.eq(SfaWorkSignRuleInfoEntity :: getUsedStatus, YesNoEnum.yesNoEnum.NO.getValue());
        iSfaWorkSignRuleInfoService.remove(lambdaQueryWrapperOfInfo);
        //只删未使用过的数据
        lambdaQueryWrapperOfRecord.eq(SfaWorkSignRecordEntity :: getUsedStatus,YesNoEnum.yesNoEnum.NO.getValue());
        iSfaWorkSignRecordService.remove(lambdaQueryWrapperOfRecord);
    }

    /**
     * 将context内无法删除的记录移除，防止写入数据库时唯一键异常
     * @param context
     * @param ruleDate
     */
    protected void removeNotDel(ExecuteSignRuleContext context, String ruleDate){
        //创建删除info Wrapper
        LambdaQueryWrapper<SfaWorkSignRuleInfoEntity> lambdaQueryWrapperOfInfo = Wrappers.lambdaQuery(SfaWorkSignRuleInfoEntity.class)
                .ge(SfaWorkSignRuleInfoEntity :: getRuleDate, ruleDate);
        lambdaQueryWrapperOfInfo.eq(SfaWorkSignRuleInfoEntity :: getUsedStatus,YesNoEnum.yesNoEnum.YES.getValue());
//        if(!org.springframework.util.CollectionUtils.isEmpty(ruleCodes)){
//            lambdaQueryWrapperOfInfo.in(SfaWorkSignRuleInfoEntity :: getRuleCode, ruleCodes);
//        }
        lambdaQueryWrapperOfInfo.select(SfaWorkSignRuleInfoEntity :: getUserName, SfaWorkSignRuleInfoEntity :: getRuleDate);
        final Set<String> usersOfNotDel = iSfaWorkSignRuleInfoService.list(lambdaQueryWrapperOfInfo).stream()
                .map(v -> v.getUserName() + "_" + v.getRuleDate()).collect(Collectors.toSet());
        List<SfaWorkSignRuleInfoEntity> infoEntities = context.getRuleInfoEntities()
                .stream().filter(v -> !(usersOfNotDel.contains(v.getUserName() + "_" + v.getRuleDate()))).collect(Collectors.toList());
        context.setRuleInfoEntities(infoEntities);
        List<SfaWorkSignRecordEntity> recordEntities = context.getRecordEntities()
                .stream().filter(v -> !(usersOfNotDel.contains(v.getWsUserName() + "_" + v.getRuleDate()))).collect(Collectors.toList());
        context.setRecordEntities(recordEntities);
    }
}
