package com.biz.crm.worksummary.controller;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryCommentReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksummary.service.ISfaWorkSummaryCommentService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 工作总结评论记录
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@RestController
@RequestMapping("/sfa-work-summary-comment-web")
@Api(tags = "WEB工作总结评论")
public class SfaWorkSummaryCommentController {
    @Autowired
    private ISfaWorkSummaryCommentService sfaWorkSummaryCommentService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryCommentRespVo>> list(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        long l = System.currentTimeMillis();
        PageResult<SfaWorkSummaryCommentRespVo> result=sfaWorkSummaryCommentService.findList(sfaWorkSummaryCommentReqVo);
        log.info("工作总结查询列表耗时={}",System.currentTimeMillis()-l);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSummaryCommentRespVo> query(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        SfaWorkSummaryCommentRespVo respVo=sfaWorkSummaryCommentService.query(sfaWorkSummaryCommentReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.save(sfaWorkSummaryCommentReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.update(sfaWorkSummaryCommentReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.deleteBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.enableBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo) {
        sfaWorkSummaryCommentService.disableBatch(sfaWorkSummaryCommentReqVo);
        return Result.ok("禁用成功");
    }
}
