package com.biz.crm.worksummary.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.worksummary.service.ISfaWorkSummaryLikeService;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryLikeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 工作总结点赞记录
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@RestController
@RequestMapping("/sfa-work-summary-like-web")
@Api(tags = "WEB工作总结点赞")
public class SfaWorkSummaryLikeController {
    @Autowired
    private ISfaWorkSummaryLikeService sfaWorkSummaryLikeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaWorkSummaryLikeRespVo>> list(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        PageResult<SfaWorkSummaryLikeRespVo> result=sfaWorkSummaryLikeService.findList(sfaWorkSummaryLikeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaWorkSummaryLikeRespVo> query(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        SfaWorkSummaryLikeRespVo respVo=sfaWorkSummaryLikeService.query(sfaWorkSummaryLikeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        SfaWorkSummaryLikeRespVo likeRespVo = sfaWorkSummaryLikeService.save(sfaWorkSummaryLikeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        sfaWorkSummaryLikeService.update(sfaWorkSummaryLikeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        sfaWorkSummaryLikeService.deleteBatch(sfaWorkSummaryLikeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        sfaWorkSummaryLikeService.enableBatch(sfaWorkSummaryLikeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo) {
        sfaWorkSummaryLikeService.disableBatch(sfaWorkSummaryLikeReqVo);
        return Result.ok("禁用成功");
    }
}
