package com.biz.crm.worksummary.mapper;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.worksummary.model.SfaWorkSummaryAtLogEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryAtLogRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryAtLogReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作总结艾特对象记录
 * 
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface SfaWorkSummaryAtLogMapper extends BaseMapper<SfaWorkSummaryAtLogEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    List<SfaWorkSummaryAtLogRespVo> findList(Page<SfaWorkSummaryAtLogRespVo> page, @Param("vo") SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 查询@自己的
     * @param atLogPage
     * @param reqVo
     * @return
     */
    List<SfaWorkSummaryAtLogRespVo> findAtLogList(Page<SfaWorkSummaryAtLogRespVo> page, @Param("vo") SfaWorkSummaryPrimaryReqVo reqVo);

    /**
     * 查询@人信息
     * @param ids
     * @return
     */
    List<SfaWorkSummaryAtLogRespVo> findListByBusinessIds(@Param("ids") List<String> ids);
}
