package com.biz.crm.worksummary.mapper;

import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryLikeReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作总结点赞记录
 * 
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface SfaWorkSummaryLikeMapper extends BaseMapper<SfaWorkSummaryLikeEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSummaryLikeReqVo
     * @return
     */
    List<SfaWorkSummaryLikeRespVo> findList(Page<SfaWorkSummaryLikeRespVo> page, @Param("vo") SfaWorkSummaryLikeReqVo sfaWorkSummaryLikeReqVo);

    /**
     * 查询点赞数
     * @param ids
     * @return
     */
    List<SfaWorkSummaryLikeRespVo> findCountByBusinessIds(@Param("businessIds") List<String> businessIds);
}
