package com.biz.crm.worksummary.mapper;

import com.biz.crm.worksummary.model.SfaWorkSummaryPictureEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPictureRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPictureReqVo;
import java.util.List;
import java.util.Map;

/**
 * 工作总结照片信息
 * 
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface SfaWorkSummaryPictureMapper extends BaseMapper<SfaWorkSummaryPictureEntity> {
    /**
     * 列表
     * @param page
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    List<SfaWorkSummaryPictureRespVo> findList(Page<SfaWorkSummaryPictureRespVo> page, @Param("vo") SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 根据关联ID集合查询照片
     * @param ids
     * @return
     */
    List<SfaWorkSummaryPictureRespVo> findListByBusinessIds(@Param("ids") List<String> ids);
}
