package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结艾特对象记录实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_at_log")
@CrmTable(name = "sfa_work_summary_at_log",tableNote = "工作总结艾特对象记录实体类",indexes = {
        @Index(name = "work_summary_at_log_index1",columnList = "summary_id")
})
public class SfaWorkSummaryAtLogEntity extends CrmExtTenEntity<SfaWorkSummaryAtLogEntity> {

    private static final long serialVersionUID = 2520452140292404195L;
    /**
     * 艾特人员code
     */
    @CrmColumn(name = "at_user_code", length = 100,note = "艾特人员code")
    private String atUserCode;

    /**
     * 工作动态ID
     */
    @CrmColumn(name = "business_id", length = 100,note = "工作动态ID")
    private String businessId;

    /**
     * 工作动态（总结）ID
     */
    @CrmColumn(name = "summary_id", length = 100,note = "工作动态（总结）ID")
    private String summaryId;
}
