package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结照片信息实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_picture")
@CrmTable(name = "sfa_work_summary_picture", tableNote = "工作总结照片信息",indexes = {
        @Index(name = "work_summary_picture_index1",columnList = "business_id")
})
public class SfaWorkSummaryPictureEntity extends CrmExtTenEntity<SfaWorkSummaryPictureEntity> {

    private static final long serialVersionUID = -315661979023023619L;
    /**
     * 图片对象名称
     */
    @CrmColumn(name = "object_name", length = 512, note = "图片对象名称")
    private String objectName;

    /**
     * 图片相对路径
     */
    @CrmColumn(name = "url_path", length = 512, note = "图片相对路径")
    private String urlPath;

    /**
     * 图片路径地址
     */
    @CrmColumn(name = "url_path_prefix", length = 512, note = "图片路径地址")
    private String urlPathPrefix;

    /**
     * 工作总结ID
     */
    @CrmColumn(name = "business_id", length = 32, note = "工作总结ID")
    private String businessId;

}
