package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_primary")
@CrmTable(name = "sfa_work_summary_primary", tableNote = "工作总结",indexes = {
        @Index(name = "work_summary_primary_index1",columnList = "summary_id")
})
public class SfaWorkSummaryPrimaryEntity extends CrmExtTenEntity<SfaWorkSummaryPrimaryEntity> {

    private static final long serialVersionUID = -4372201311079280097L;
    /**
     * 动态
     */
    @CrmColumn(name = "dynamic", length = 512, note = "动态")
    private String dynamic;

    /**
     * 转发关联工作总结Id
     */
    @CrmColumn(name = "summary_id", length = 32, note = "转发关联工作总结Id")
    private String summaryId;

    /**
     * 工作总结
     */
    @CrmColumn(name = "summary", length = 512, note = "工作总结")
    private String summary;

    /**
     * 工作计划
     */
    @CrmColumn(name = "plan", length = 512, note = "工作计划")
    private String plan;

    /**
     * 类型(DAILY_日报,WEEKLY_周报,MONTHLY_月报,EXPERIENCE_心得)
     */
    @CrmColumn(name = "lecture_type", length = 20, note = "类型(DAILY_日报,WEEKLY_周报,MONTHLY_月报,EXPERIENCE_心得)")
    private String lectureType;

    /**
     * 定位信息
     */
    @CrmColumn(name = "location", length = 512, note = "定位信息")
    private String location;

}
