package com.biz.crm.worksummary.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 工作总结可见权限实体类
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_work_summary_scope")
@CrmTable(name = "sfa_work_summary_scope", tableNote = "工作总结可见权限",indexes = {
        @Index(name = "work_summary_scope_index1",columnList = "business_id")
})
public class SfaWorkSummaryScopeEntity extends CrmExtTenEntity<SfaWorkSummaryScopeEntity> {

    private static final long serialVersionUID = -7711520828340644900L;
    /**
     * 权限类型
     */
    @CrmColumn(name = "scope_type", length = 20, note = "权限类型")
    private String scopeType;

    /**
     * 权限范围code（组织code/人员code）
     */
    @CrmColumn(name = "scope_code", length = 32, note = "权限范围code（组织code/人员code）")
    private String scopeCode;

    /**
     * 计数
     */
    @CrmColumn(name = "scope_count", mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "计数")
    private Integer scopeCount;

    /**
     * 工作总结动态ID
     */
    @CrmColumn(name = "business_id", length = 32, note = "工作总结动态ID")
    private String businessId;

}
