package com.biz.crm.worksummary.service;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryAtLogReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryAtLogRespVo;
import com.biz.crm.worksummary.model.SfaWorkSummaryAtLogEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Map;

/**
 * 工作总结艾特对象记录接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryAtLogService extends IService<SfaWorkSummaryAtLogEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryAtLogReqVo
     * @return PageResult<SfaWorkSummaryAtLogRespVo>
     */
    PageResult<SfaWorkSummaryAtLogRespVo> findList(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryAtLogReqVo
     * @return SfaWorkSummaryAtLogRespVo
     */
    SfaWorkSummaryAtLogRespVo query(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    void save(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    void update(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryAtLogReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryAtLogReqVo sfaWorkSummaryAtLogReqVo);
}

