package com.biz.crm.worksummary.service;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryCommentReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryCommentRespVo;
import com.biz.crm.worksummary.model.SfaWorkSummaryCommentEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.Map;

/**
 * 工作总结评论记录接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryCommentService extends IService<SfaWorkSummaryCommentEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryCommentReqVo
     * @return PageResult<SfaWorkSummaryCommentRespVo>
     */
    PageResult<SfaWorkSummaryCommentRespVo> findList(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryCommentReqVo
     * @return SfaWorkSummaryCommentRespVo
     */
    SfaWorkSummaryCommentRespVo query(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    void save(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    void update(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryCommentReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryCommentReqVo sfaWorkSummaryCommentReqVo);
}

