package com.biz.crm.worksummary.service;

import com.biz.crm.worksummary.model.SfaWorkSummaryPictureEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPictureRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPictureReqVo;

import java.util.Map;

/**
 * 工作总结照片信息接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryPictureService extends IService<SfaWorkSummaryPictureEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryPictureReqVo
     * @return PageResult<SfaWorkSummaryPictureRespVo>
     */
    PageResult<SfaWorkSummaryPictureRespVo> findList(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryPictureReqVo
     * @return SfaWorkSummaryPictureRespVo
     */
    SfaWorkSummaryPictureRespVo query(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    void save(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    void update(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryPictureReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryPictureReqVo sfaWorkSummaryPictureReqVo);
}

