package com.biz.crm.worksummary.service;

import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPrimaryReqVo;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPrimaryRespVo;
import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 工作总结接口
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
public interface ISfaWorkSummaryPrimaryService extends IService<SfaWorkSummaryPrimaryEntity> {

    /**
     * 列表
     * @param sfaWorkSummaryReqVo
     * @return PageResult<SfaWorkSummaryRespVo>
     */
    PageResult<SfaWorkSummaryPrimaryRespVo> findList(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 查询
     * @param sfaWorkSummaryReqVo
     * @return SfaWorkSummaryRespVo
     */
    SfaWorkSummaryPrimaryRespVo query(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 新增
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void save(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 更新
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void update(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 删除
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void deleteBatch(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 启用
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void enableBatch(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 禁用
     * @param sfaWorkSummaryReqVo
     * @return
     */
    void disableBatch(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);

    /**
     * 查询转发列表
     * @param sfaWorkSummaryReqVo
     * @return
     */
    PageResult<SfaWorkSummaryPrimaryRespVo> forwradList(SfaWorkSummaryPrimaryReqVo sfaWorkSummaryReqVo);
}

