package com.biz.crm.worksummary.service.impl;

import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksummary.model.SfaWorkSummaryAtLogEntity;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryAtLogMapper;
import com.biz.crm.worksummary.service.ISfaWorkSummaryAtLogService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryAtLogRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryAtLogReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 工作总结艾特对象记录接口实现
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaWorkSummaryAtLogServiceExpandImpl")
public class SfaWorkSummaryAtLogServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaWorkSummaryAtLogMapper, SfaWorkSummaryAtLogEntity> implements ISfaWorkSummaryAtLogService {

    @Resource
    private SfaWorkSummaryAtLogMapper sfaWorkSummaryAtLogMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryAtLogRespVo> findList(SfaWorkSummaryAtLogReqVo reqVo){
        Page<SfaWorkSummaryAtLogRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSummaryAtLogRespVo> list = sfaWorkSummaryAtLogMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSummaryAtLogRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSummaryAtLogRespVo
     */
    @Override
    public SfaWorkSummaryAtLogRespVo query(SfaWorkSummaryAtLogReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSummaryAtLogReqVo reqVo){
        SfaWorkSummaryAtLogEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSummaryAtLogEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSummaryAtLogReqVo reqVo){
        SfaWorkSummaryAtLogEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSummaryAtLogReqVo reqVo){
        List<SfaWorkSummaryAtLogEntity> sfaWorkSummaryAtLogEntities = sfaWorkSummaryAtLogMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryAtLogEntities)){
            sfaWorkSummaryAtLogEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryAtLogEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSummaryAtLogReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSummaryAtLogEntity> sfaWorkSummaryAtLogEntities = sfaWorkSummaryAtLogMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryAtLogEntities)){
            sfaWorkSummaryAtLogEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryAtLogEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSummaryAtLogReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSummaryAtLogEntity> sfaWorkSummaryAtLogEntities = sfaWorkSummaryAtLogMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryAtLogEntities)){
                sfaWorkSummaryAtLogEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryAtLogEntities);
    }
}
