package com.biz.crm.worksummary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.*;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryCommentMapper;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPrimaryMapper;
import com.biz.crm.worksummary.model.SfaWorkSummaryCommentEntity;
import com.biz.crm.worksummary.model.SfaWorkSummaryPrimaryEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.worksummary.model.SfaWorkSummaryLikeEntity;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryLikeMapper;
import com.biz.crm.worksummary.service.ISfaWorkSummaryLikeService;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryLikeRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryLikeReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 工作总结点赞记录接口实现
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaWorkSummaryLikeServiceExpandImpl")
public class SfaWorkSummaryLikeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaWorkSummaryLikeMapper, SfaWorkSummaryLikeEntity> implements ISfaWorkSummaryLikeService {

    @Resource
    private SfaWorkSummaryLikeMapper sfaWorkSummaryLikeMapper;

    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Autowired
    private SfaWorkSummaryPrimaryMapper sfaWorkSummaryPrimaryMapper;

    @Autowired
    private SfaWorkSummaryCommentMapper sfaWorkSummaryCommentMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryLikeRespVo> findList(SfaWorkSummaryLikeReqVo reqVo){
        Page<SfaWorkSummaryLikeRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSummaryLikeRespVo> list = sfaWorkSummaryLikeMapper.findList(page, reqVo);
        if(!CollectionUtils.isEmpty(list)){
            //点赞人
            Set<String> createCodes = Sets.newHashSet();
            list.forEach(o -> {
                createCodes.add(o.getCreateCode());
            });
            //查询人员信息
            MdmPositionUserOrgReqVo userQueryVo = new MdmPositionUserOrgReqVo();
            userQueryVo.setPrimaryFlag("1");
            userQueryVo.setUserNameList(createCodes.stream().collect(Collectors.toList()));
            List<MdmPositionUserOrgRespVo> userOrgRespVos = ApiResultUtil.objResult(mdmPositionFeign.findPositionUserOrgList(userQueryVo));
            Map<String, MdmPositionUserOrgRespVo> userOrgRespVoMap = userOrgRespVos.stream()
                    .collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, Function.identity()));

            list.forEach(o -> {
                String businessId = o.getId();
                String id = o.getId();
                //头像
                MdmPositionUserOrgRespVo userOrgRespVo = userOrgRespVoMap.get(o.getCreateCode());
                o.setPhoto(userOrgRespVo.getUserHeadUrl());
            });
        }
        return PageResult.<SfaWorkSummaryLikeRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSummaryLikeRespVo
     */
    @Override
    public SfaWorkSummaryLikeRespVo query(SfaWorkSummaryLikeReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public SfaWorkSummaryLikeRespVo save(SfaWorkSummaryLikeReqVo reqVo){
        SfaWorkSummaryLikeRespVo respVo = new SfaWorkSummaryLikeRespVo();
        ValidateUtils.validate(reqVo.getBusinessId(),"被点赞数据ID不能为空");
        //ValidateUtils.validate(reqVo.getSummaryId(),"工作总结ID不能为空");
        UserRedis user = UserUtils.getUser();
        //查询总结
        SfaWorkSummaryPrimaryEntity summaryPrimaryEntity = sfaWorkSummaryPrimaryMapper.selectById(reqVo.getBusinessId());
        if(!ObjectUtils.isEmpty(summaryPrimaryEntity)){
            reqVo.setSummaryId(summaryPrimaryEntity.getId());
        }else{
            //查询评论
            SfaWorkSummaryCommentEntity summaryCommentEntity = sfaWorkSummaryCommentMapper.selectById(reqVo.getBusinessId());
            if(!ObjectUtils.isEmpty(summaryCommentEntity)){
                reqVo.setSummaryId(summaryCommentEntity.getSummaryId());
            }else{
                throw new BusinessException("businessId数据异常");
            }
        }


        LambdaQueryWrapper<SfaWorkSummaryLikeEntity> build = new LambdaQueryWrapper<SfaWorkSummaryLikeEntity>()
                .eq(SfaWorkSummaryLikeEntity::getBusinessId,reqVo.getBusinessId())
                .eq(SfaWorkSummaryLikeEntity::getSummaryId,reqVo.getSummaryId())
                .eq(SfaWorkSummaryLikeEntity::getCreateCode,user.getUsername());
        SfaWorkSummaryLikeEntity sfaWorkSummaryLikeEntity = sfaWorkSummaryLikeMapper.selectOne(build);
        if(ObjectUtils.isEmpty(sfaWorkSummaryLikeEntity)) {
            SfaWorkSummaryLikeEntity entity = CrmBeanUtil.copy(reqVo, SfaWorkSummaryLikeEntity.class);
            this.save(entity);
        }else{
            sfaWorkSummaryLikeMapper.deleteById(sfaWorkSummaryLikeEntity.getId());
        }
        return respVo;
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSummaryLikeReqVo reqVo){
        SfaWorkSummaryLikeEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSummaryLikeReqVo reqVo){
        List<SfaWorkSummaryLikeEntity> sfaWorkSummaryLikeEntities = sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if(!CollectionUtils.isEmpty(sfaWorkSummaryLikeEntities)){
            sfaWorkSummaryLikeEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSummaryLikeReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSummaryLikeEntity> sfaWorkSummaryLikeEntities = sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if(!CollectionUtils.isEmpty(sfaWorkSummaryLikeEntities)){
            sfaWorkSummaryLikeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSummaryLikeReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSummaryLikeEntity> sfaWorkSummaryLikeEntities = sfaWorkSummaryLikeMapper.selectBatchIds(reqVo.getIds());
        if(!CollectionUtils.isEmpty(sfaWorkSummaryLikeEntities)){
                sfaWorkSummaryLikeEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryLikeEntities);
    }
}
