package com.biz.crm.worksummary.service.impl;

import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.worksummary.model.SfaWorkSummaryPictureEntity;
import com.biz.crm.worksummary.mapper.SfaWorkSummaryPictureMapper;
import com.biz.crm.worksummary.service.ISfaWorkSummaryPictureService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.sfa.worksummary.resp.SfaWorkSummaryPictureRespVo;
import com.biz.crm.nebular.sfa.worksummary.req.SfaWorkSummaryPictureReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 工作总结照片信息接口实现
 *
 * @author Gavin
 * @date 2021-03-06 11:00:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaWorkSummaryPictureServiceExpandImpl")
public class SfaWorkSummaryPictureServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaWorkSummaryPictureMapper, SfaWorkSummaryPictureEntity> implements ISfaWorkSummaryPictureService {

    @Resource
    private SfaWorkSummaryPictureMapper sfaWorkSummaryPictureMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaWorkSummaryPictureRespVo> findList(SfaWorkSummaryPictureReqVo reqVo){
        Page<SfaWorkSummaryPictureRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaWorkSummaryPictureRespVo> list = sfaWorkSummaryPictureMapper.findList(page, reqVo);
        return PageResult.<SfaWorkSummaryPictureRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaWorkSummaryPictureRespVo
     */
    @Override
    public SfaWorkSummaryPictureRespVo query(SfaWorkSummaryPictureReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaWorkSummaryPictureReqVo reqVo){
        SfaWorkSummaryPictureEntity entity = CrmBeanUtil.copy(reqVo,SfaWorkSummaryPictureEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaWorkSummaryPictureReqVo reqVo){
        SfaWorkSummaryPictureEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaWorkSummaryPictureReqVo reqVo){
        List<SfaWorkSummaryPictureEntity> sfaWorkSummaryPictureEntities = sfaWorkSummaryPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryPictureEntities)){
            sfaWorkSummaryPictureEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryPictureEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaWorkSummaryPictureReqVo reqVo){
        //设置状态为启用
        List<SfaWorkSummaryPictureEntity> sfaWorkSummaryPictureEntities = sfaWorkSummaryPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryPictureEntities)){
            sfaWorkSummaryPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryPictureEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaWorkSummaryPictureReqVo reqVo){
        //设置状态为禁用
        List<SfaWorkSummaryPictureEntity> sfaWorkSummaryPictureEntities = sfaWorkSummaryPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaWorkSummaryPictureEntities)){
                sfaWorkSummaryPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaWorkSummaryPictureEntities);
    }
}
