/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.ai.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.model.SfaActivityProductEntity;
import com.biz.crm.activity.service.ISfaActivityProductService;
import com.biz.crm.ai.mapper.SfaAiTaskMapper;
import com.biz.crm.ai.model.SfaAiProductEntity;
import com.biz.crm.ai.model.SfaAiTaskEntity;
import com.biz.crm.ai.model.SfaAiTaskExtEntity;
import com.biz.crm.ai.service.SfaAiProductService;
import com.biz.crm.ai.service.SfaAiTaskExtService;
import com.biz.crm.ai.service.SfaAiTaskService;
import com.biz.crm.ai.util.AiTaskStatusEnums;
import com.biz.crm.ai.util.AiUtil;
import com.biz.crm.ai.vo.AiCallBackDto;
import com.biz.crm.ai.vo.recognition.result.GoodInfo;
import com.biz.crm.ai.vo.recognition.result.RecognitionResponse;
import com.biz.crm.ai.vo.recognition.result.RecognitionResultVo;
import com.biz.crm.ai.vo.recognition.task.ImgInfo;
import com.biz.crm.ai.vo.recognition.task.ImgLibInfo;
import com.biz.crm.ai.vo.recognition.task.Recognition;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskDto;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskVo;
import com.biz.crm.base.CrmAttachment;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SfaAiTaskServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAiTaskMapper, SfaAiTaskEntity>
implements SfaAiTaskService {
    private static final Logger log = LoggerFactory.getLogger(SfaAiTaskServiceImpl.class);
    @Value(value="${sfa.ai.appkey:}")
    private String appKey;
    @Value(value="${sfa.ai.enterpriseid:}")
    private String enterpriseId;
    @Value(value="${sfa.ai.appsecret:}")
    private String appSecret;
    @Value(value="${sfa.ai.callback.recognition-url:}")
    private String recognitionUrl;
    @Value(value="${sfa.ai.callback.repeat-url:}")
    private String repeatUrl;
    private static final String LABELS = "ALL";
    @Resource
    private SfaAiTaskExtService sfaAiTaskExtService;
    @Resource
    private ISfaActivityProductService sfaActivityProductService;
    @Resource
    private SfaAiProductService sfaAiProductService;
    @Resource
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;

    @Override
    @Transactional
    public void startRecognitionTask(String stepId, String stepCode, String executionId, String clientCode, List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList) {
        log.info("\r\n*startRecognitionTask*[{}],[{}],[{}],[{}],[{}]**\r\n", new Object[]{stepId, stepCode, executionId, clientCode, JSONUtil.toJsonStr(activityRequireReqVoList)});
        if (CollectionUtils.isEmpty(activityRequireReqVoList)) {
            return;
        }
        ArrayList imgList = Lists.newArrayList();
        for (ActivityStepExecuteData.ActivityRequireReqVo item : activityRequireReqVoList) {
            if (!"2".equals(item.getActivityRequire()) || !CollectionUtils.isNotEmpty(item.getPictureList())) continue;
            for (CrmAttachment sub : item.getPictureList()) {
                if (!StringUtils.isNotBlank((CharSequence)sub.getUrl())) continue;
                imgList.add(sub.getUrl());
            }
        }
        if (CollectionUtils.isEmpty((Collection)imgList)) {
            return;
        }
        log.info("enterpriseId={},appKey={},appSecret={}", new Object[]{this.enterpriseId, this.appKey, this.appSecret});
        AiUtil aiUtil = AiUtil.aiBuilder().setEnterpriseId(this.enterpriseId).setAppKey(this.appKey).setAppSecret(this.appSecret).bulid();
        RecognitionTaskVo recognitionTaskVo = aiUtil.submitRecognitionTask(this.getRecognitionTaskDto(clientCode, imgList));
        SfaAiTaskEntity sfaAiTaskEntity = new SfaAiTaskEntity();
        sfaAiTaskEntity.setStepId(stepId);
        sfaAiTaskEntity.setStepCode(stepCode);
        sfaAiTaskEntity.setId(stepId);
        sfaAiTaskEntity.setExecutionId(executionId);
        sfaAiTaskEntity.setClientCode(clientCode);
        sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.RECOGNITION_STATUS_2.getValue());
        sfaAiTaskEntity.setRecognitionTaskId("");
        sfaAiTaskEntity.setRepeatTaskId("");
        sfaAiTaskEntity.setErrMsg("");
        if (recognitionTaskVo != null) {
            sfaAiTaskEntity.setRecognitionTaskId(recognitionTaskVo.getTaskId());
            sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.RECOGNITION_STATUS_1.getValue());
        }
        this.saveOrUpdate((Object)sfaAiTaskEntity);
        SfaAiTaskExtEntity sfaAiTaskExtEntity = new SfaAiTaskExtEntity();
        sfaAiTaskExtEntity.setId(stepId);
        sfaAiTaskExtEntity.setParentId(stepId);
        sfaAiTaskExtEntity.setReqParamsJson(JSONUtil.toJsonStr(activityRequireReqVoList));
        sfaAiTaskExtEntity.setReqTime(LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        sfaAiTaskExtEntity.setRecognitionJson("");
        sfaAiTaskExtEntity.setRecognitionTime("");
        sfaAiTaskExtEntity.setRepeatJson("");
        sfaAiTaskExtEntity.setRepeatTime("");
        this.sfaAiTaskExtService.saveOrUpdate((Object)sfaAiTaskExtEntity);
    }

    @Override
    public void startRecognitionTaskNew(String stepId, String stepCode, String executionId, String clientCode, List<ActivityStepExecuteData.ActivityRequireReqVo> activityRequireReqVoList) {
        log.info("\r\n*startRecognitionTaskNew*[{}],[{}],[{}],[{}],[{}]**\r\n", new Object[]{stepId, stepCode, executionId, clientCode, JSONUtil.toJsonStr(activityRequireReqVoList)});
        if (CollectionUtils.isEmpty(activityRequireReqVoList)) {
            return;
        }
        ArrayList imgList = Lists.newArrayList();
        for (ActivityStepExecuteData.ActivityRequireReqVo item : activityRequireReqVoList) {
            if (!"2".equals(item.getActivityRequire()) || !CollectionUtils.isNotEmpty(item.getPictureList())) continue;
            for (CrmAttachment sub : item.getPictureList()) {
                if (!StringUtils.isNotBlank((CharSequence)sub.getUrl())) continue;
                imgList.add(sub.getUrl());
            }
        }
        if (CollectionUtils.isEmpty((Collection)imgList)) {
            return;
        }
        log.info("enterpriseId={},appKey={},appSecret={}", new Object[]{this.enterpriseId, this.appKey, this.appSecret});
        AiUtil aiUtil = AiUtil.aiBuilder().setEnterpriseId(this.enterpriseId).setAppKey(this.appKey).setAppSecret(this.appSecret).bulid();
        RecognitionTaskDto recognitionTaskDto = this.getRecognitionTaskDto(clientCode, imgList);
        RecognitionResultVo recognitionResultVo = aiUtil.execRecognitionTask(recognitionTaskDto);
        SfaAiTaskEntity sfaAiTaskEntity = new SfaAiTaskEntity();
        sfaAiTaskEntity.setStepId(stepId);
        sfaAiTaskEntity.setStepCode(stepCode);
        sfaAiTaskEntity.setId(stepId);
        sfaAiTaskEntity.setExecutionId(executionId);
        sfaAiTaskEntity.setClientCode(clientCode);
        sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.RECOGNITION_STATUS_2.getValue());
        sfaAiTaskEntity.setRecognitionTaskId("");
        sfaAiTaskEntity.setRepeatTaskId("");
        sfaAiTaskEntity.setErrMsg("");
        SfaAiTaskExtEntity sfaAiTaskExtEntity = new SfaAiTaskExtEntity();
        sfaAiTaskExtEntity.setId(stepId);
        sfaAiTaskExtEntity.setParentId(stepId);
        sfaAiTaskExtEntity.setReqParamsJson(JSONUtil.toJsonStr((Object)recognitionTaskDto));
        sfaAiTaskExtEntity.setReqTime(LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        sfaAiTaskExtEntity.setRecognitionJson("");
        sfaAiTaskExtEntity.setRecognitionTime("");
        sfaAiTaskExtEntity.setRepeatJson("");
        sfaAiTaskExtEntity.setRepeatTime("");
        if (recognitionResultVo == null || CollectionUtils.isEmpty(recognitionResultVo.getRecognitionResponseList())) {
            sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.FAIL.getValue());
        } else {
            this.displayTaskCheck(sfaAiTaskEntity, sfaAiTaskExtEntity, this.getAiRecognitionGoodsMap(recognitionResultVo));
            sfaAiTaskExtEntity.setRecognitionJson(JSONUtil.toJsonStr((Object)recognitionResultVo));
        }
        this.saveOrUpdate((Object)sfaAiTaskEntity);
        this.sfaAiTaskExtService.saveOrUpdate((Object)sfaAiTaskExtEntity);
        if (sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.FAIL.getValue())) {
            sfaAiTaskEntity.setErrMsg("\u9648\u5217\u8981\u6c42\u672a\u8fbe\u6807");
        }
        if (sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.FAIL.getValue()) || sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.SUCCESS.getValue())) {
            this.sfaVisitStepActivityExecutionService.finishDisplayVisitStep(sfaAiTaskEntity.getStepId(), sfaAiTaskEntity.getStepCode(), sfaAiTaskEntity.getTaskStatus(), sfaAiTaskEntity.getErrMsg());
        }
    }

    @Override
    @Transactional
    public void recognitionCallBack(AiCallBackDto dto) {
        log.info("\r\n*recognitionCallBack[{}]*\n", (Object)JSONUtil.toJsonStr((Object)dto));
        SfaAiTaskEntity sfaAiTaskEntity = this.findByRecognitionTaskId(dto.getTaskId());
        if (sfaAiTaskEntity == null) {
            log.error("\u8bc6\u522b\u4efb\u52a1\u4e0d\u5b58\u5728[{}]", (Object)dto);
            return;
        }
        SfaAiTaskExtEntity sfaAiTaskExtEntity = this.findExtEntityById(sfaAiTaskEntity.getId());
        if (sfaAiTaskExtEntity == null) {
            log.error("\u8bc6\u522b\u4efb\u52a1\u4e0d\u5b58\u5728ext[{}]", (Object)dto);
            return;
        }
        if (sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.FAIL.getValue()) || sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.SUCCESS.getValue())) {
            log.info("**recognitionCallBack**[{}],[{}]", (Object)JSONUtil.toJsonStr((Object)dto), (Object)sfaAiTaskEntity.getTaskStatus());
            return;
        }
        log.info("enterpriseId={},appKey={},appSecret={}", new Object[]{this.enterpriseId, this.appKey, this.appSecret});
        AiUtil aiUtil = AiUtil.aiBuilder().setEnterpriseId(this.enterpriseId).setAppKey(this.appKey).setAppSecret(this.appSecret).bulid();
        RecognitionResultVo recognitionResultVo = aiUtil.recognitionResult(dto.getTaskId());
        sfaAiTaskExtEntity.setRecognitionTime(LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (recognitionResultVo == null || CollectionUtils.isEmpty(recognitionResultVo.getRecognitionResponseList())) {
            sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.FAIL.getValue());
        } else {
            this.displayTaskCheck(sfaAiTaskEntity, sfaAiTaskExtEntity, this.getAiRecognitionGoodsMap(recognitionResultVo));
            sfaAiTaskExtEntity.setRecognitionJson(JSONUtil.toJsonStr((Object)recognitionResultVo));
        }
        this.saveOrUpdate((Object)sfaAiTaskEntity);
        this.sfaAiTaskExtService.saveOrUpdate((Object)sfaAiTaskExtEntity);
        if (sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.FAIL.getValue())) {
            sfaAiTaskEntity.setErrMsg("\u9648\u5217\u8981\u6c42\u672a\u8fbe\u6807");
        }
        if (sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.FAIL.getValue()) || sfaAiTaskEntity.getTaskStatus().equals(AiTaskStatusEnums.SUCCESS.getValue())) {
            this.sfaVisitStepActivityExecutionService.finishDisplayVisitStep(sfaAiTaskEntity.getStepId(), sfaAiTaskEntity.getStepCode(), sfaAiTaskEntity.getTaskStatus(), sfaAiTaskEntity.getErrMsg());
        }
    }

    @Transactional
    public void displayTaskCheck(SfaAiTaskEntity sfaAiTaskEntity, SfaAiTaskExtEntity sfaAiTaskExtEntity, Map<String, Integer> goodsInfoMap) {
        Map<Object, Object> mapProductDisplayNum = Maps.newHashMap();
        List activityProductEntities = ((LambdaQueryChainWrapper)this.sfaActivityProductService.lambdaQuery().eq(SfaActivityProductEntity::getActivityExecutionId, (Object)sfaAiTaskEntity.getExecutionId())).select(new SFunction[]{SfaActivityProductEntity::getProductCode, SfaActivityProductEntity::getDisplayNum}).list();
        if (CollectionUtils.isNotEmpty((Collection)activityProductEntities)) {
            mapProductDisplayNum = activityProductEntities.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getProductCode()) && NumberUtil.isNumber((CharSequence)a.getDisplayNum())).collect(Collectors.toMap(SfaActivityProductEntity::getProductCode, SfaActivityProductEntity::getDisplayNum, (a, b) -> a));
        }
        if (!this.validateTask(mapProductDisplayNum, goodsInfoMap)) {
            sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.FAIL.getValue());
            sfaAiTaskEntity.setErrMsg("\u9648\u5217\u8981\u6c42\u672a\u8fbe\u6807");
        } else {
            sfaAiTaskEntity.setTaskStatus(AiTaskStatusEnums.SUCCESS.getValue());
        }
    }

    @Override
    @Transactional
    public void repeatCallBack(AiCallBackDto dto) {
    }

    @Override
    public void test(String taskId, String status) {
        this.sfaVisitStepActivityExecutionService.deleteAll();
    }

    private RecognitionTaskDto getRecognitionTaskDto(String clientCode, List<String> imgList) {
        RecognitionTaskDto dto = new RecognitionTaskDto();
        dto.setCallbackUrl(this.recognitionUrl);
        dto.setImgUrls(imgList);
        Recognition recognition = new Recognition();
        ImgInfo imgInfo = new ImgInfo();
        imgInfo.setEnterpriseId(this.enterpriseId);
        imgInfo.setShotTime(System.currentTimeMillis() + "");
        imgInfo.setStoreId(clientCode);
        recognition.setImgInfo(imgInfo);
        ImgLibInfo imgLibInfo = new ImgLibInfo();
        imgLibInfo.setEnable(true);
        imgLibInfo.setLabels(Lists.newArrayList((Object[])new String[]{LABELS}));
        recognition.setImgLibInfo(imgLibInfo);
        dto.setRecognition(recognition);
        return dto;
    }

    private Map<String, Integer> getAiRecognitionGoodsMap(RecognitionResultVo recognitionResultVo) {
        List mapEntities;
        HashMap map = Maps.newHashMap();
        HashMap re = Maps.newHashMap();
        for (RecognitionResponse recognitionResponse : recognitionResultVo.getRecognitionResponseList()) {
            for (GoodInfo goodInfo : recognitionResponse.getGoodsInfo()) {
                map.put(goodInfo.getCode(), map.getOrDefault(goodInfo.getCode(), 0) + 1);
            }
        }
        if (map != null && !map.isEmpty() && CollectionUtils.isNotEmpty((Collection)(mapEntities = ((LambdaQueryChainWrapper)this.sfaAiProductService.lambdaQuery().in(SfaAiProductEntity::getCode, map.keySet())).select(new SFunction[]{SfaAiProductEntity::getCode, SfaAiProductEntity::getProductCode}).list()))) {
            Map<String, String> map1 = mapEntities.stream().collect(Collectors.toMap(SfaAiProductEntity::getProductCode, SfaAiProductEntity::getCode));
            for (Map.Entry entry : map1.entrySet()) {
                re.put(entry.getKey(), map.get(entry.getValue()));
            }
        }
        return re;
    }

    private boolean validateTask(Map<String, String> mapProductDisplayNum, Map<String, Integer> goodsInfoMap) {
        if (mapProductDisplayNum == null || goodsInfoMap == null || mapProductDisplayNum.isEmpty() || goodsInfoMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, String> item : mapProductDisplayNum.entrySet()) {
            if (goodsInfoMap.getOrDefault(item.getKey(), 0).compareTo(Integer.valueOf(item.getValue())) >= 0) continue;
            return false;
        }
        return true;
    }

    private SfaAiTaskEntity findByRecognitionTaskId(String taskId) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAiTaskEntity::getRecognitionTaskId, (Object)taskId)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SfaAiTaskEntity)((Object)list.get(0));
        }
        return null;
    }

    private SfaAiTaskEntity findByRepeatTaskId(String taskId) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaAiTaskEntity::getRepeatTaskId, (Object)taskId)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SfaAiTaskEntity)((Object)list.get(0));
        }
        return null;
    }

    private SfaAiTaskExtEntity findExtEntityById(String id) {
        return (SfaAiTaskExtEntity)((Object)this.sfaAiTaskExtService.getById((Serializable)((Object)id)));
    }
}

