/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.ai.util;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.biz.crm.ai.util.AiBuilder;
import com.biz.crm.ai.util.AiRequestBase;
import com.biz.crm.ai.util.AiResultUtil;
import com.biz.crm.ai.vo.AiResult;
import com.biz.crm.ai.vo.label.LabelCreateVo;
import com.biz.crm.ai.vo.recognition.result.RecognitionResultVo;
import com.biz.crm.ai.vo.recognition.task.ImgInfo;
import com.biz.crm.ai.vo.recognition.task.ImgLibInfo;
import com.biz.crm.ai.vo.recognition.task.Recognition;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskDto;
import com.biz.crm.ai.vo.recognition.task.RecognitionTaskVo;
import com.biz.crm.ai.vo.repeat.result.RepeatResultVo;
import com.biz.crm.ai.vo.repeat.task.RepeatTaskDto;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiUtil
extends AiRequestBase {
    private static final Logger log = LoggerFactory.getLogger(AiUtil.class);

    public static AiBuilder aiBuilder() {
        return new AiBuilder();
    }

    public String cosApi() {
        Map param = MapUtil.builder(new HashMap()).put((Object)"enterpriseId", (Object)this.enterpriseId).build();
        String executeUrl = this.url("api.display.v1.uploadImg", "1.0.0", JSONUtil.toJsonStr((Object)param));
        log.info("executeUrl:{},param:{}", (Object)executeUrl, (Object)JSONUtil.toJsonStr((Object)param));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)param)).execute();
            log.info(execute.body());
            return execute.body();
        }
        catch (Exception e) {
            log.info("\u8bf7\u6c42AI\u4e34\u65f6\u5bc6\u94a5\u5931\u8d25:{}", (Object)JSONUtil.toJsonStr((Object)param));
            return null;
        }
    }

    public LabelCreateVo createLabel(List<String> labels, String enterpriseId) {
        Map param = MapUtil.builder(new HashMap()).put((Object)"enterpriseId", (Object)enterpriseId).put((Object)"labels", labels).build();
        String executeUrl = this.url("api.display.v1.label.create", "1.0.0", JSONUtil.toJsonStr((Object)param));
        log.info("executeUrl:{},param:{}", (Object)executeUrl, (Object)JSONUtil.toJsonStr((Object)param));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)param)).execute();
            log.info("\r\n createLabel->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<LabelCreateVo>>(){}, (boolean)false);
            return (LabelCreateVo)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42AI\u521b\u5efa\u67e5\u91cd\u5e93\u5931\u8d25:{},{}", (Object)JSONUtil.toJsonStr((Object)param), (Object)e);
            return null;
        }
    }

    public RecognitionResultVo execRecognitionTask(RecognitionTaskDto dto) {
        RecognitionTaskVo vo = this.submitRecognitionTask(dto);
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getTaskId())) {
            return null;
        }
        RecognitionResultVo recognitionResultVo = this.recognitionResult(vo.getTaskId());
        return recognitionResultVo;
    }

    public RecognitionResultVo execRecognitionTask(String dto) {
        RecognitionTaskVo vo = this.submitRecognitionTask(dto);
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getTaskId())) {
            return null;
        }
        RecognitionResultVo recognitionResultVo = this.recognitionResult(vo.getTaskId());
        return recognitionResultVo;
    }

    public RecognitionTaskVo submitRecognitionTask(RecognitionTaskDto dto) {
        String executeUrl = this.url("api.display.v1.recognition.task", "1.0.0", JSONUtil.toJsonStr((Object)dto));
        log.info("executeUrl:{},param:{}", (Object)executeUrl, (Object)JSONUtil.toJsonStr((Object)dto));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)dto)).execute();
            log.info("\r\n submitRecognitionTask->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<RecognitionTaskVo>>(){}, (boolean)false);
            return (RecognitionTaskVo)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42AI\u8bc6\u522b\u4efb\u52a1\u5931\u8d25:{},{}", (Object)JSONUtil.toJsonStr((Object)dto), (Object)e);
            return null;
        }
    }

    public RecognitionTaskVo submitRecognitionTask(String dto) {
        String executeUrl = this.url("api.display.v1.recognition.task", "1.0.0", dto);
        log.info("submitRecognitionTask****executeUrl:{},param:{}", (Object)executeUrl, (Object)dto);
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(dto).execute();
            log.info("\r\n submitRecognitionTask->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<RecognitionTaskVo>>(){}, (boolean)false);
            return (RecognitionTaskVo)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RecognitionResultVo recognitionResult(String taskId) {
        Map param = MapUtil.builder(new HashMap()).put((Object)"enterpriseId", (Object)this.enterpriseId).put((Object)"taskId", (Object)taskId).build();
        String executeUrl = this.url("api.display.v1.recognition.result", "1.0.0", JSONUtil.toJsonStr((Object)param));
        log.info("recognitionResult****executeUrl:{},param:{}", (Object)executeUrl, (Object)JSONUtil.toJsonStr((Object)param));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)param)).execute();
            log.info("\r\n recognitionResult->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<RecognitionResultVo>>(){}, (boolean)false);
            return (RecognitionResultVo)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42AI\u4efb\u52a1\u7ed3\u679c\u5931\u8d25:{},{}", (Object)JSONUtil.toJsonStr((Object)param), (Object)e);
            return null;
        }
    }

    public String submitRepeatTask(RepeatTaskDto dto) {
        dto.setEnterpeiseId(this.enterpriseId);
        String executeUrl = this.url("api.display.v1.repeat.task", "1.0.0", JSONUtil.toJsonStr((Object)dto));
        log.info("executeUrl:{},param:{}", (Object)executeUrl, (Object)JSONUtil.toJsonStr((Object)dto));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)dto)).execute();
            log.info("\r\n submitRepeatTask->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<String>>(){}, (boolean)false);
            return (String)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42AI\u8bc6\u522b\u4efb\u52a1\u5931\u8d25:{},{}", (Object)JSONUtil.toJsonStr((Object)dto), (Object)e);
            return null;
        }
    }

    public RepeatResultVo repeatResult(String taskId) {
        Map param = MapUtil.builder(new HashMap()).put((Object)"enterpriseId", (Object)this.enterpriseId).put((Object)"taskId", (Object)taskId).build();
        String executeUrl = this.url("api.display.v1.repeat.result", "1.0.0", JSONUtil.toJsonStr((Object)param));
        try {
            HttpResponse execute = HttpRequest.post((String)executeUrl).body(JSONUtil.toJsonStr((Object)param)).execute();
            log.info("\r\n repeatResult->{}\r\n", (Object)execute.body());
            AiResult result = (AiResult)JSONUtil.toBean((String)execute.body(), (TypeReference)new TypeReference<AiResult<RepeatResultVo>>(){}, (boolean)false);
            return (RepeatResultVo)AiResultUtil.objResult(result, true);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42AI\u4efb\u52a1\u7ed3\u679c\u5931\u8d25:{},{}", (Object)JSONUtil.toJsonStr((Object)param), (Object)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String appKey = "2e23f8520fa9";
        String appSecret = "78f7e7429e7b4aa8a0170671eeb39e95";
        String enterpriseId = "3506857863977547733";
        AiUtil ai = AiUtil.aiBuilder().setAppKey(appKey).setAppSecret(appSecret).setEnterpriseId(enterpriseId).bulid();
        String msg = "{\n  \"imgUrls\": [\n    \"https://uma-shop-recognition-qa-1302115263.cos.ap-guangzhou.myqcloud.com/display/3506857863977547733/2021/9/26/1632636969238_951128.jpg\"\n  ],\n  \"callbackUrl\": \"https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack\",\n  \"recognition\": {\n    \"imgInfo\": {\n      \"enterpriseId\": \"3506857863977547733\",\n      \"latitude\": \"000\",\n      \"longitude\": \"3.6\",\n      \"storeId\": \"ZD00000152\",\n      \"shotTime\": \"1623130416000\"\n    },\n    \"imgLibInfo\": {\n      \"enable\": true,\n      \"labels\": [\n        \"ALL\"\n      ]\n    }\n  }\n}";
        String url = "\"https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack\"";
        String str = "\"https://uma-shop-recognition-qa-1302115263.cos.ap-guangzhou.myqcloud.com/display/3506857863977547733/2021/9/26/1632636969238_951128.jpg\"";
        String reqBodyStr = "{\"imgUrls\":[" + str + "],\"callbackUrl\":" + url + ",\"recognition\":{\"imgInfo\":{\"enterpriseId\":\"3506857863977547733\",\"latitude\":\"000\",\"longitude\":\"3.6\",\"storeId\":\"ZD00000152\",\"shotTime\":\"1623130416000\"},\"imgLibInfo\":{\"enable\":true,\"labels\":[\"ALL\"]}}}";
        RecognitionTaskDto dto = AiUtil.getRecognitionTaskDto("ZD00000152", Lists.newArrayList((Object[])new String[]{"https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/6df2ad7d0e334493b31fa1c6a3dc9c4f.jpg", "https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210928/dfcaf463e2684f1f9cc157007595deed.jpg"}));
        String msg1 = "{\"imgUrls\":[\"https://bizcrm.oss-cn-beijing.aliyuncs.com/jpg/20210930/1a202c8f2ca7418e9ede43e1ad83b573.jpg\"],\"recognition\":{\"imgInfo\":{\"shotTime\":\"1632980217883\",\"storeId\":\"ZD00000152\",\"enterpriseId\":\"3506857863977547733\"},\"imgLibInfo\":{\"labels\":[\"ALL\"],\"enable\":true}},\"callbackUrl\":\"https://crmtest.biz-united.com.cn/sfa/ai/displayApiController/recognitionCallBack\"}";
        RecognitionResultVo recognitionResultVo = ai.recognitionResult("861e89a121b811ec88549ac9502ce7fc");
        System.out.println(JSONUtil.toJsonPrettyStr((Object)recognitionResultVo));
    }

    private static RecognitionTaskDto getRecognitionTaskDto(String clientCode, List<String> imgList) {
        String callbackUrl = "https://ec5apitest.swellfun.com/rest/display/ai/v1/displayCallBack";
        RecognitionTaskDto dto = new RecognitionTaskDto();
        dto.setCallbackUrl(callbackUrl);
        dto.setImgUrls(imgList);
        Recognition recognition = new Recognition();
        ImgInfo imgInfo = new ImgInfo();
        imgInfo.setEnterpriseId("3506857863977547733");
        imgInfo.setStoreId(clientCode);
        imgInfo.setLatitude("23.3");
        imgInfo.setLongitude("23.3");
        imgInfo.setShotTime("1623130416000");
        recognition.setImgInfo(imgInfo);
        ImgLibInfo imgLibInfo = new ImgLibInfo();
        imgLibInfo.setEnable(true);
        imgLibInfo.setLabels(Lists.newArrayList((Object[])new String[]{"ALL"}));
        recognition.setImgLibInfo(imgLibInfo);
        dto.setRecognition(recognition);
        return dto;
    }
}

