/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.audit.service.ISfaAuditTpmService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTpmReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaTPMTerminalReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmActInfoRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTpmRespVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaaudittpm"})
@Api(tags={"TPM\u7a3d\u67e5\u7ed3\u679c"})
public class SfaAuditTpmController {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditTpmController.class);
    @Autowired
    private ISfaAuditTpmService sfaAuditTpmService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaAuditTpmRespVo>> list(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        PageResult<SfaAuditTpmRespVo> result = this.sfaAuditTpmService.findList(sfaAuditTpmReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaAuditTpmRespVo> query(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        SfaAuditTpmRespVo respVo = this.sfaAuditTpmService.query(sfaAuditTpmReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        this.sfaAuditTpmService.save(sfaAuditTpmReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        this.sfaAuditTpmService.update(sfaAuditTpmReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        this.sfaAuditTpmService.deleteBatch(sfaAuditTpmReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        this.sfaAuditTpmService.enableBatch(sfaAuditTpmReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody SfaAuditTpmReqVo sfaAuditTpmReqVo) {
        this.sfaAuditTpmService.disableBatch(sfaAuditTpmReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7ec8\u7aef-\u67e5\u770bTPM\u7a3d\u67e5\u7ec8\u7aef\u4fe1\u606f")
    @PostMapping(value={"/queryTPMInfo"})
    @CrmLog
    public Result queryTPMInfo(@RequestBody SfaTPMTerminalReqVo reqVo) {
        List<MdmTerminalVo> mdmTerminalVos = this.sfaAuditTpmService.queryTpmInfo(reqVo);
        return Result.ok(mdmTerminalVos);
    }

    @ApiOperation(value="\u7ec8\u7aef-\u67e5\u770bTPM\u7ec8\u7aef\u7a3d\u67e5\u8bb0\u5f55")
    @PostMapping(value={"/queryByTerminalCode"})
    @CrmLog
    public Result queryByTerminalCode(@RequestBody SfaAuditTpmReqVo reqVo) {
        List<SfaAuditTpmRespVo> sfaAuditTpmRespVos = this.sfaAuditTpmService.queryTpmByTerminalCode(reqVo);
        return Result.ok(sfaAuditTpmRespVos);
    }

    @ApiOperation(value="\u7ec8\u7aef-\u67e5\u770b\u5df2\u7a3d\u67e5TPM\u6d3b\u52a8\u4fe1\u606f")
    @PostMapping(value={"/queryTpmAuditAct"})
    @CrmLog
    public Result queryTpmAuditAct(@RequestBody SfaTpmActReqVo reqVo) {
        List<SfaTpmActRespVo> sfaTpmActRespVos = this.sfaAuditTpmService.queryTpmAuditAct(reqVo);
        return Result.ok(sfaTpmActRespVos);
    }

    @ApiOperation(value="\u7ec8\u7aef-\u67e5\u770b\u5f85\u7a3d\u67e5TPM\u6d3b\u52a8\u4fe1\u606f")
    @PostMapping(value={"/queryTpmToAuditAct"})
    @CrmLog
    public Result queryTpmToAuditAct(@RequestBody SfaTpmActReqVo reqVo) {
        List<SfaTpmActRespVo> sfaTpmActRespVos = this.sfaAuditTpmService.queryTpmToAuditAct(reqVo);
        return Result.ok(sfaTpmActRespVos);
    }

    @ApiOperation(value="\u7ec8\u7aef-\u67e5\u770bTPM\u6d3b\u52a8\u8be6\u60c5")
    @PostMapping(value={"/queryTpmActDetail"})
    @CrmLog
    public Result queryTpmActDetail(@RequestBody SfaAuditTpmReqVo reqVo) {
        List<SfaAuditTpmActInfoRespVo> respList = this.sfaAuditTpmService.queryTpmActDetail(reqVo);
        return Result.ok(respList);
    }

    @ApiOperation(value="\u67e5\u770bTPM\u8d39\u7528\u6d3b\u52a8\u7a3d\u67e5\u660e\u7ec6")
    @PostMapping(value={"/queryTpmActAuditDetail"})
    @CrmLog
    public Result queryTpmActAuditDetail(@RequestBody SfaAuditTpmReqVo reqVo) {
        List<SfaAuditTpmActInfoRespVo> respVos = this.sfaAuditTpmService.queryTpmActAuditDetail(reqVo);
        return Result.ok(respVos);
    }
}

