/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditInspectorsMapper;
import com.biz.crm.audit.model.SfaAuditInspectorsEntity;
import com.biz.crm.audit.service.ISfaAuditInspectorsService;
import com.biz.crm.audit.trans.SfaAuditInspectorEntityToResp;
import com.biz.crm.audit.trans.SfaAuditInspectorsReqToEntity;
import com.biz.crm.audit.utils.Constant;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditInspectorsReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditInspectorsRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaAuditInspectorsServiceExpandImpl"})
public class SfaAuditInspectorsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAuditInspectorsMapper, SfaAuditInspectorsEntity>
implements ISfaAuditInspectorsService {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditInspectorsServiceImpl.class);
    @Resource
    private SfaAuditInspectorsMapper sfaAuditInspectorsMapper;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<SfaAuditInspectorsRespVo> findList(SfaAuditInspectorsReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaAuditInspectorsRespVo> list = this.sfaAuditInspectorsMapper.findList((Page<SfaAuditInspectorsRespVo>)page, reqVo);
        for (SfaAuditInspectorsRespVo respVo : list) {
            SfaAuditInspectorsEntity entity = (SfaAuditInspectorsEntity)((Object)this.sfaAuditInspectorsMapper.selectById((Serializable)((Object)respVo.getId())));
            SfaAuditInspectorsRespVo apply = new SfaAuditInspectorEntityToResp().apply(entity);
            respVo.setAuditArea(apply.getAuditArea());
            respVo.setAuditAreaCode(apply.getAuditAreaCode());
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaAuditInspectorsRespVo query(SfaAuditInspectorsReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditInspectorsEntity entity = (SfaAuditInspectorsEntity)((Object)this.sfaAuditInspectorsMapper.selectById((Serializable)((Object)reqVo.getId())));
        return new SfaAuditInspectorEntityToResp().apply(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAuditInspectorsReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditAccount(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditInspectorsEntity respVo = this.sfaAuditInspectorsMapper.queryInfoByAccount(reqVo.getAuditAccount());
        SfaAuditInspectorsEntity entity = (SfaAuditInspectorsEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAuditInspectorsEntity.class));
        List auditAreaCodeList = reqVo.getAuditAreaCode();
        String auditAreaCode = Constant.NULLT;
        String auditArea = Constant.NULLT;
        if (CollectionUtils.isNotEmpty((Collection)auditAreaCodeList)) {
            auditAreaCode = StringUtils.join((Iterable)auditAreaCodeList, (String)",");
        }
        Result listResult = this.mdmOrgFeign.detailBatchByOrgCodeList(auditAreaCodeList);
        List result = (List)listResult.getResult();
        List collect = result.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.toList());
        auditArea = StringUtils.join(collect, (String)",");
        entity.setAuditAreaCode(auditAreaCode);
        entity.setAuditArea(auditArea);
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaAuditInspectorsReqVo reqVo) {
        SfaAuditInspectorsEntity apply = new SfaAuditInspectorsReqToEntity().apply(reqVo);
        this.updateById((Object)apply);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaAuditInspectorsReqVo reqVo) {
        List sfaAuditInspectorsEntities = this.sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditInspectorsEntities)) {
            sfaAuditInspectorsEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaAuditInspectorsReqVo reqVo) {
        List sfaAuditInspectorsEntities = this.sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditInspectorsEntities)) {
            sfaAuditInspectorsEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaAuditInspectorsReqVo reqVo) {
        List sfaAuditInspectorsEntities = this.sfaAuditInspectorsMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditInspectorsEntities)) {
            sfaAuditInspectorsEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaAuditInspectorsEntities);
    }

    @Override
    public SfaAuditInspectorsRespVo queryInfoByAccount(String auditAccount) {
        AssertUtils.isNotEmpty((String)auditAccount, (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditInspectorsEntity entity = this.sfaAuditInspectorsMapper.queryInfoByAccount(auditAccount);
        return new SfaAuditInspectorEntityToResp().apply(entity);
    }
}

