/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditProductPriceMapper;
import com.biz.crm.audit.mapper.SfaAuditProductPriceProMapper;
import com.biz.crm.audit.model.SfaAuditProductPriceEntity;
import com.biz.crm.audit.service.ISfaAuditProductPriceProService;
import com.biz.crm.audit.service.ISfaAuditProductPriceService;
import com.biz.crm.audit.utils.AuditAccountUtils;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceProReqVo;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditProductPriceReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceProRespVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditProductPriceRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaAuditProuditPriceServiceExpandImpl"})
public class SfaAuditProductPriceServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAuditProductPriceMapper, SfaAuditProductPriceEntity>
implements ISfaAuditProductPriceService {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditProductPriceServiceImpl.class);
    @Resource
    private SfaAuditProductPriceMapper sfaAuditProuditPriceMapper;
    @Resource
    private SfaAuditProductPriceProMapper sfaAuditProductPriceProMapper;
    @Resource
    private ISfaAuditProductPriceProService iSfaAuditProductPriceProService;

    @Override
    public PageResult<SfaAuditProductPriceRespVo> findList(SfaAuditProductPriceReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaAuditProductPriceRespVo> list = this.sfaAuditProuditPriceMapper.findList((Page<SfaAuditProductPriceRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaAuditProductPriceRespVo query(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditProductPriceEntity entity = (SfaAuditProductPriceEntity)((Object)this.sfaAuditProuditPriceMapper.selectById((Serializable)((Object)reqVo.getId())));
        SfaAuditProductPriceRespVo respVo = (SfaAuditProductPriceRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaAuditProductPriceRespVo.class);
        List<SfaAuditProductPriceProRespVo> proList = this.sfaAuditProductPriceProMapper.findListByProductId(respVo.getId());
        respVo.setProductPriceProRespVos(proList);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditAccount(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setAuditCode(CodeUtil.createCode());
        reqVo.setAuditProductQuantity(Integer.valueOf(reqVo.getAuditProductList().size()));
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        List auditProductList = reqVo.getAuditProductList();
        Integer unqualifiedProductQuantity = 0;
        if (CollectionUtils.isNotEmpty((Collection)auditProductList)) {
            for (SfaAuditProductPriceProRespVo vo : auditProductList) {
                if (!vo.getSalesTarget().booleanValue()) {
                    Integer n = unqualifiedProductQuantity;
                    Integer n2 = unqualifiedProductQuantity = Integer.valueOf(unqualifiedProductQuantity + 1);
                    reqVo.setAuditResult(Boolean.valueOf(false));
                }
                SfaAuditProductPriceProReqVo copy = (SfaAuditProductPriceProReqVo)CrmBeanUtil.copy((Object)vo, SfaAuditProductPriceProReqVo.class);
                copy.setAuditCode(reqVo.getAuditCode());
                this.iSfaAuditProductPriceProService.save(copy);
            }
        }
        reqVo.setUnqualifiedProductQuantity(unqualifiedProductQuantity);
        SfaAuditProductPriceEntity entity = (SfaAuditProductPriceEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAuditProductPriceEntity.class));
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaAuditProductPriceReqVo reqVo) {
        SfaAuditProductPriceEntity entity = (SfaAuditProductPriceEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaAuditProductPriceReqVo reqVo) {
        List sfaAuditProuditPriceEntities = this.sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditProuditPriceEntities)) {
            sfaAuditProuditPriceEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaAuditProductPriceReqVo reqVo) {
        List sfaAuditProuditPriceEntities = this.sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditProuditPriceEntities)) {
            sfaAuditProuditPriceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaAuditProductPriceReqVo reqVo) {
        List sfaAuditProuditPriceEntities = this.sfaAuditProuditPriceMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditProuditPriceEntities)) {
            sfaAuditProuditPriceEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaAuditProuditPriceEntities);
    }

    @Override
    public List<SfaAuditProductPriceRespVo> queryProductAudit(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SfaAuditProductPriceRespVo> respVos = this.sfaAuditProuditPriceMapper.queryByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditProductPriceRespVo queryProductAuditDetail(SfaAuditProductPriceReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditCode(), (String)"\u7a3d\u67e5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditProductPriceRespVo respVos = this.sfaAuditProuditPriceMapper.queryAuditDetailByCode(reqVo);
        return respVos;
    }
}

