/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.SfaAuditTerminalRealMapper;
import com.biz.crm.audit.model.SfaAuditTerminalRealEntity;
import com.biz.crm.audit.service.ISfaAuditTerminalRealService;
import com.biz.crm.audit.utils.AuditAccountUtils;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.audit.req.SfaAuditTerminalRealReqVo;
import com.biz.crm.nebular.sfa.audit.resp.SfaAuditTerminalRealRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaAuditTerminalRealServiceExpandImpl"})
public class SfaAuditTerminalRealServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaAuditTerminalRealMapper, SfaAuditTerminalRealEntity>
implements ISfaAuditTerminalRealService {
    private static final Logger log = LoggerFactory.getLogger(SfaAuditTerminalRealServiceImpl.class);
    @Resource
    private SfaAuditTerminalRealMapper sfaAuditTerminalRealMapper;

    @Override
    public PageResult<SfaAuditTerminalRealRespVo> findList(SfaAuditTerminalRealReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<SfaAuditTerminalRealRespVo> list = this.sfaAuditTerminalRealMapper.findList((Page<SfaAuditTerminalRealRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaAuditTerminalRealRespVo query(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditTerminalRealEntity sfaAuditTerminalRealEntity = (SfaAuditTerminalRealEntity)((Object)this.sfaAuditTerminalRealMapper.selectById((Serializable)((Object)reqVo.getId())));
        SfaAuditTerminalRealRespVo respVo = (SfaAuditTerminalRealRespVo)CrmBeanUtil.copy((Object)((Object)sfaAuditTerminalRealEntity), SfaAuditTerminalRealRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditAccount(), (String)"\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setAuditCode(CodeUtil.createCode());
        Map<String, String> areaInfo = new AuditAccountUtils().getAreaInfo(reqVo.getAuditAccount());
        SfaAuditTerminalRealEntity entity = (SfaAuditTerminalRealEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaAuditTerminalRealEntity.class));
        entity.setAuditAreaCode(areaInfo.get("code"));
        entity.setAuditArea(areaInfo.get("name"));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaAuditTerminalRealReqVo reqVo) {
        SfaAuditTerminalRealEntity entity = (SfaAuditTerminalRealEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaAuditTerminalRealReqVo reqVo) {
        List sfaAuditTerminalRealEntities = this.sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTerminalRealEntities)) {
            sfaAuditTerminalRealEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaAuditTerminalRealReqVo reqVo) {
        List sfaAuditTerminalRealEntities = this.sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTerminalRealEntities)) {
            sfaAuditTerminalRealEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaAuditTerminalRealReqVo reqVo) {
        List sfaAuditTerminalRealEntities = this.sfaAuditTerminalRealMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaAuditTerminalRealEntities)) {
            sfaAuditTerminalRealEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaAuditTerminalRealEntities);
    }

    @Override
    public List<SfaAuditTerminalRealRespVo> queryTerminalAudit(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<SfaAuditTerminalRealRespVo> respVos = this.sfaAuditTerminalRealMapper.queryAuditByTerminalCode(reqVo);
        return respVos;
    }

    @Override
    public SfaAuditTerminalRealRespVo queryTerminalAuditDetail(SfaAuditTerminalRealReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getAuditCode(), (String)"\u7a3d\u67e5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SfaAuditTerminalRealRespVo respVo = this.sfaAuditTerminalRealMapper.queryAuditByAuditCode(reqVo);
        return respVo;
    }
}

